% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importInfoExFreeFormText.R
\name{importInfoExFreeFromText}
\alias{importInfoExFreeFromText}
\title{Retrieve freeform text records from InfoEx and write into PostgreSQL/PostGIS GPS database.}
\usage{
importInfoExFreeFromText(Operation, TargetSchema, TargetTbl,
  DBType = "Main", Name = NA, DateStart = NA, DateEnd = DateStart,
  NewRecordsOnly = T, SkipMissingLoc = F, Overwrite = F,
  UserConfirm = T, Verbose = F, SuppressPostgreSQLWarnings = T)
}
\arguments{
\item{Operation}{Name of operation}

\item{TargetSchema}{Name of schema that includes target table}

\item{TargetTbl}{name of target table}

\item{DBType}{Optional variable for specifying which database type the location catalog should be imported. Values can be 'Main' (default) or 'NodeJS'.}

\item{Name}{Name of free form text content that should be extracted. Default value is NA.}

\item{DateStart}{Start date in YYYY-MM-DD format. Default value is NA.}

\item{DateEnd}{End date in YYYY-MM-DD format. Default value is DateStart.}

\item{NewRecordsOnly}{Boolean flag for importing new records only. Default is T.}

\item{SkipMissingLoc}{Switch for whether records of missing locations should be skipped or produce an error. Default is F.}

\item{Overwrite}{Boolean flag for whether the entire wxobs table should be overwritten (i.e., all records deleted first). Default is F.}
}
\description{
Retrieve freeform text records from InfoEx and write into PostgreSQL/PostGIS GPS database.
}
