% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importInfoExLocCatalog.R
\name{importInfoExLocCatalog}
\alias{importInfoExLocCatalog}
\title{Retrieve location catalog from InfoEx and write into PostgreSQL/PostGIS GPS database.}
\usage{
importInfoExLocCatalog(Operation, DBType = "Main", NewRecordsOnly = T,
  OpArea_Include = T, OpArea_Overwrite = F, Zone_Include = T,
  Zone_Overwrite = F, SkiRun_Include = T, SkiRun_Overwrite = F,
  SkiLine_Include = T, SkiLine_Overwrite = F, WxSite_Include = T,
  WxSite_Overwrite = F)
}
\arguments{
\item{Operation}{Name of operation}

\item{DBType}{Optional variable for specifying which database type the location catalog should be imported. Values can be 'Main' (default) or 'NodeJS}

\item{NewRecordsOnly}{Boolean flag for importing new records only. Default is T.}

\item{OpArea_Include}{Boolean flag for whether oparea table should be updated. Default is T.}

\item{OpArea_Overwrite}{Boolean flag for whether the entire oparea table should be overwritten (i.e., all records deleted first). Default is F.}

\item{Zone_Include}{Boolean flag for whether zones table should be updated. Default is T.}

\item{Zone_Overwrite}{Boolean flag for whether the entire zones table should be overwritten (i.e., all records deleted first). Default is F.}

\item{SkiRun_Include}{Boolean flag for whether skiruns table should be updated. Default is T.}

\item{SkiRun_Overwrite}{Boolean flag for whether the entire skiruns table should be overwritten (i.e., all records deleted first). Default is F.}

\item{SkiLine_Include}{Boolean flag for whether skilines table should be updated. Default is T.}

\item{SkiLine_Overwrite}{Boolean flag for whether the entire skilines table should be overwritten (i.e., all records deleted first). Default is F.}

\item{WxSite_Include}{Boolean flag for whether wxsites table should be updated. Default is T.}

\item{WxSite_Overwrite}{Boolean flag for whether the entire wxsites table should be overwritten (i.e., all records deleted first). Default is F.}
}
\description{
Retrieve location catalog from InfoEx and write into PostgreSQL/PostGIS GPS database.
}
