% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importSnowbaseCapacity.R
\name{importSnowbaseCapacity}
\alias{importSnowbaseCapacity}
\title{Import capacity table from Roger}
\usage{
importSnowbaseCapacity(Operation, FileName, DBTbl = "zones_daily",
  DBType = "Main", ShowCounter = 500, Overwrite = F)
}
\arguments{
\item{Operation}{Name of operation}

\item{FileName}{Name of csv file to be imported including full path}

\item{DBTbl}{Name of capacity table for data import. Only zobnes_daily implemented so far.}

\item{DBType}{Optional variable for specifying which database type the location catalog should be imported. Values can be 'Main' (default) or 'NodeJS}

\item{ShowCounter}{Interval for showing progress counter.}

\item{Overwrite}{Boolean flag for whether the entire avobs table should be overwritten (i.e., all records deleted first). Default is F.}
}
\description{
Import simulated capacity table from Roger. Currently only implemented for zones_daily table
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "CMHGL"

Folder <- "C:\\\\Users\\\\Pascal\\\\Documents\\\\Pascal\\\\SFU\\\\Students-Current\\\\SterchiReto\\\\Paper1_DataCollection\\\\CapacityData\\\\"
File <- "Zone_Daily.csv"

importSnowbaseCapacity(Operation, FileName=paste0(Folder, File), Overwrite=T)
}
