% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_AllGPSRunsOnSkiRunSkiLine.R
\name{plot.AllGPSRunsOnSkiRunSkiLine}
\alias{plot.AllGPSRunsOnSkiRunSkiLine}
\title{Plots all of the GPS tracks associated with a ski run or run line from the locacation catalog.}
\usage{
plot.AllGPSRunsOnSkiRunSkiLine(Oper, RunName, DEM,
  BackgroundType = "Terrain", GPSTracks = NULL, LocCat = NULL,
  LocCatCentroids = NULL)
}
\arguments{
\item{Oper}{Abbreviation of operation}

\item{RunName}{Name of run}

\item{DEM}{DEM raster for background}

\item{BackgroundType}{Type of background image. Default is 'Terrain'. Other option is 'Slope'.}

\item{GPSTracks}{Optional parameter for passing GPS tracks. This is to improve efficiency if you produce multiple charts for the same GPS tracks.}

\item{LocCat}{Optional parameter for passing location catalog. Default is NULL, which means that the location catalog is retrieved within the function.}

\item{LocCatCentroids}{Optional parameter for passing location catalog with centroids. Default is NULL, which means that the location catalog is retrieved within the function.}
}
\value{
RunsObject with GPS tracks.
}
\description{
Plots all of the GPS tracks associated with a ski run or run line from the locacation catalog
}
\examples{
require(SarpGPSToolsPrivate)
require(SarpGPSTools)

Oper <- "CMHGL"

DEM <- getDEM(Oper, highres=T, localpath = "C:/Temp/Test")
LocCat <- getLocCatlog(Oper, LocalProjection = F)
LocCatC <- getLocCatlog(Oper, LocalProjection = F, AsCentroidsSkiRuns = T)

RunName1 <- c("Bunker Hill")
RunName2 <- c("TNT")

par(mfrow=c(2,2))
par(mar=c(0.5,0.5,4.1,0.5))
GPSTracks1 <- plot.AllGPSRunsOnSkiRunSkiLine(Oper = Oper, RunName = RunName1, 
                                             DEM = DEM, BackgroundType = "Terrain", 
                                             LocCat = LocCat, LocCatCentroids = LocCatC)

GPSTracks2 <- plot.AllGPSRunsOnSkiRunSkiLine(Oper = Oper, RunName = RunName2, 
                                             DEM = DEM, BackgroundType = "Terrain", 
                                             LocCat = LocCat, LocCatCentroids = LocCatC)

plot.AllGPSRunsOnSkiRunSkiLine(Oper = Oper, RunName = RunName1, 
                               DEM = DEM, BackgroundType = "Slope", 
                               GPSTracks = GPSTracks1,
                               LocCat = LocCat, LocCatCentroids = LocCatC)

plot.AllGPSRunsOnSkiRunSkiLine(Oper = Oper, RunName = RunName2, 
                               DEM = DEM, BackgroundType = "Slope", 
                               GPSTracks = GPSTracks2,
                               LocCat = LocCat, LocCatCentroids = LocCatC)
par(mfrow=c(1,1))
par(mar=c(5.1,4.1,4.1,2.1))

}
