% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_LocCatalog.R
\name{plot.LocCatalog}
\alias{plot.LocCatalog}
\title{Plots LocCatalog object.}
\usage{
plot.LocCatalog(LocCatalog, main = "Location Catalog", ZoomArea = NA,
  DEM = NULL, WithTerrainCol = T, WithContours = F, ShowZones = T,
  ColZones = "grey", ShowCatRoads = T, ColCatRoads = "brown",
  ShowSkiRuns = T, ColSkiRuns = "#e41a1c",
  ShowSkiRunSegments = FALSE, ColSkiRunSegments = c("#a1d99b",
  "#9ecae1", "#bdbdbd"), TransSkiRunSegments = 85, ShowSkiLines = T,
  ColSkiLines = "#e41a1c", ShowWxSites = T, ColWxSites = "skyblue",
  ShowLandings = T, ColLandings = c("red", "blue"), ShowCruxes = T,
  ColCruxes = "red", ShowClusters = F, ColClusters = "grey", ...)
}
\arguments{
\item{main}{Title for plot. Default is "GPS Tracks of Ski Runs".}

\item{ZoomArea}{Name or names of an area (e.g., zones, ski run) that the map should focus on. Default is NA , which zooms into the Operating area}

\item{DEM}{Raster DEM with elevation values for plotting terrain background}

\item{ShowZones}{Switch for showing zones. Default is TRUE.}

\item{ShowCatRoads}{Switch for showing cat roads. Default is TRUE.}

\item{ShowSkiRuns}{Switch for showing ski runs. Default is TRUE.}

\item{ShowSkiRunSegments}{Switch for showing ski run segements. This only works for NEH. Default is FALSE.}

\item{ShowSkiLines}{Switch for showing ski lines. Default is TRUE.}

\item{ShowLandings}{Switch for showing helicopter landings and pickups. Default is TRUE.}

\item{ShowCruxes}{Switch for showing cruxes. Default is TRUE.}

\item{ShowClusters}{Switch for showing run clusters. Default is FALSE.}

\item{LocCatalogObject}{LocCatalog object}

\item{ShowWxSite}{Switch for showing weather sites. Default is TRUE.}
}
\description{
Plots LocCatalog object.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "CMHGL"
LocCat <- getLocCatlog(Operation)
plot(LocCat, main='CMH Galena')

## Include terrain
DEM <- getDEM(Operation)
plot.LocCatalog(LocCat, DEM=DEM, WithTerrainCol = F) ## Grey scale in 500m intervals
plot.LocCatalog(LocCat, DEM=DEM)  ## Terrain coloring

Operation <- "MPS"
LocCat <- getLocCatlog(Operation, AsCentroidsSkiRuns = T, AsCentroidsSkiLines = T)
plot(LocCat, main='Monashee Powder')

Operation <- "NEH"
LocCat <- getLocCatlog(Operation)
plot(LocCat, ZoomArea=c("Promised Land", "Wild West"))

}
