% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RunsObject.R
\name{plot.RunsObject}
\alias{plot.RunsObject}
\title{Plots RunsObject.}
\usage{
plot.RunsObject(RunsObject, WithObsPoints = T, WithPausePoints = T,
  main = "GPS Tracks of Ski Runs")
}
\arguments{
\item{RunsObject}{RunsObject object}

\item{WithObsPoints}{Switch for whether ObsPoints should be included. Default is TRUE.}

\item{WithPausePoints}{Switch for whether PausePoints should be included. Default is TRUE.}

\item{main}{Title for plot. Default is "GPS Tracks of Ski Runs".}
}
\description{
Plots RunsObject.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "NEH"
RunUUIDs <- getRunUUIDsFromTrackerUnitAndDate(Operation, "13", "2015-02-02")
Runs <- getRunsObjectFromUUIDs(Operation, RunUUIDs)
plot(Runs, main="Runs tracked by Unit 13 on 2015-02-02")
plot(Runs, main="Runs tracked by Unit 13 on 2015-02-02", WithObsPoints=FALSE)
plot(Runs, main="Runs tracked by Unit 13 on 2015-02-02", WithObsPoints=FALSE, WithPausePoints=FALSE)

}
