% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHzdChart.R
\name{plotHzdChart}
\alias{plotHzdChart}
\title{Plot hazard chart from avalanche problem component of hazard assessment object.}
\usage{
plotHzdChart(AvProblems, AvProblemsFaded = NULL,
  Title = "Hazard Chart", WithPoints = T, RatingCol = NA,
  RatingLoc = c(7, 7), RatingSize = 0.8, Transparency = "50",
  Shape = "square", NumPoints = 50, SuppressWarnings = T,
  cex.axis = 0.5, cex.lab = 0.5)
}
\arguments{
\item{AvProblems}{DF with avalanche problems.}

\item{AvProblemsFaded}{DF with avalanche problems to be plotted faded.}

\item{Title}{Title of chart. Default value is 'Hazard Chart'.}

\item{WithPoints}{Switch whether chart should be plotted with points. Default is TRUE.}

\item{RatingCol}{Colors for ratings bull's eye (alp, tl, btl)}

\item{RatingLoc}{Location of rating bull's eye. Array of x and y. Default value c(7,7).}

\item{RatingSize}{Size of rating bull's eye. Default value 0.8.}

\item{Transparency}{The transparency of the blob background. Value can be between 00 and 99. Default value is 50.}

\item{Shape}{For specifying the shape of the blob. Values can be 'ellipse' (default) or 'square'.}

\item{NumPoints}{Number of point per quater section of ellipse. Default value is 50.}

\item{SuppressWarnings}{Switch for suppressing warning message about application of is.na to S4 object. Default is TRUE.}

\item{cex.axis}{cex.axis (default=0.5)}

\item{cex.lab}{cex.lab (default=0.5)}
}
\description{
Plot hazard chart from avalanche problem component of hazard assessment object.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "NEH"

DateStart <- "2016-02-01"
DateEnd   <- "2016-02-10"
DateSeq   <- as.character(seq(from=as.Date(DateStart), to=as.Date(DateEnd), by=1))

## Daily plots with ellipses for date sequence including hazard ratings
for (Index in 1:length(DateSeq)) {
  HzdAssess <- getInfoExHzdAssessObject(Operation, DateStart=DateSeq[Index], Time = "PM")
  HzdRating <- c(HzdAssess$HzdAssess$alp_hzd[1], HzdAssess$HzdAssess$tl_hzd[1], HzdAssess$HzdAssess$btl_hzd[1])
  HzdCol <- getHzdColor(HzdRating)
  plotHzdChart(HzdAssess$AvProb, Title=paste("Hzd Chart -", DateSeq[Index], " (PM)"), Shape="square", RatingCol = HzdCol)
}
 
## All problems for date sequence as squares
HzdAssess <- getInfoExHzdAssessObject(Operation, DateStart=DateStart, DateEnd=DateEnd, Time = "PM")
plotHzdChart(HzdAssess$AvProb, Title=paste("Hzd Chart -", DateStart, " to ", DateEnd, " (PM)"), Shape = "square")

## All problems for entire season as squares
DateStart <- "2016-01-01"
DateEnd   <- "2016-04-01"
HzdAssessSeason <- getInfoExHzdAssessObject(Operation, DateStart=DateStart, DateEnd=DateEnd, Time = "PM")
plotHzdChart(HzdAssessSeason$AvProb, Title=paste("All Av Problems - Season 2016 (PM)"), Shape = "square")

## Specific avalanche problems for entire season as squares 
plotHzdChart(HzdAssessSeason$AvProb[HzdAssessSeason$AvProb$character=="WIND_SLAB",], Title=paste("Wind Slabs - Season 2016 (PM)"), Shape = "square")
plotHzdChart(HzdAssessSeason$AvProb[HzdAssessSeason$AvProb$character=="STORM_SLAB",], Title=paste("Strom Slabs - Season 2016 (PM)"), Shape = "square")
plotHzdChart(HzdAssessSeason$AvProb[HzdAssessSeason$AvProb$character=="PERSISTENT_SLAB",], Title=paste("Pers Slabs - Season 2016 (PM)"), Shape = "square")
plotHzdChart(HzdAssessSeason$AvProb[HzdAssessSeason$AvProb$character=="PERSISTENT_SLAB"|HzdAssessSeason$AvProb$character=="DEEP_PERSISTENT_SLAB",], Title=paste("Pers and Deep Pers Slabs - Season 2016 (PM)"), Shape = "square")

}
