% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHzdChartCount.R
\name{plotHzdChartCount}
\alias{plotHzdChartCount}
\title{Plot raster in hazard chart with counts or percentages of avalanche problems.}
\usage{
plotHzdChartCount(AvProblems, Title = "Hazard Chart", WithContours = T,
  Percent = F, PercentInterval = 5, Shape = "ellipse",
  NumPoints = 50, cex.AdditionalText = 0.66, SuppressWarnings = T)
}
\arguments{
\item{AvProblems}{DF with avalanche problems}

\item{Title}{Title of chart. Default value is 'Hazard Chart'.}

\item{WithContours}{Switch whether chart should be plotted with contour lines. Default is TRUE.}

\item{Percent}{Switch whether plotted values should be percentages instead of counts. Default is F.}

\item{PercentInterval}{If percentage values are plotted with contour lines, this parameter specifies the contour intervals.}

\item{Shape}{For specifying the shape of the blob. Values can be 'ellipse' (default) or 'square'.}

\item{NumPoints}{Number of point per quater section of ellipse. Default value is 50.}

\item{cex.AdditionalText}{Scalling factor for additional text. Default value is 0.66.}

\item{SuppressWarnings}{Switch for suppressing warning message about application of is.na to S4 object. Default is TRUE.}
}
\description{
Plot raster in hazard chart with counts or percentages of avalanche problems.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "NEH"

## All problems for entire season as squares
DateStart <- "2016-01-01"
DateEnd   <- "2016-04-01"
HzdAssessSeason <- getInfoExHzdAssessObject(Operation, DateStart=DateStart, DateEnd=DateEnd, Time = "PM")
plotHzdChart(HzdAssessSeason$AvProb, Title=paste("All Av Problems - Season 2016 (PM)"), Shape = "square")
plotHzdChartCount(HzdAssessSeason$AvProb, Title=paste("All Av Problems - Season 2016 (PM)"), Shape = "square", WithContours=F)
plotHzdChartCount(HzdAssessSeason$AvProb, Title=paste("All Av Problems - Season 2016 (PM)"), Shape = "square", Percent=T)
plotHzdChartCount(HzdAssessSeason$AvProb, Title=paste("All Av Problems - Season 2016 (PM)"), Shape = "ellipse", Percent=T)

plotHzdChartCount(HzdAssessSeason$AvProb[HzdAssessSeason$AvProb$character=="WIND_SLAB",], Title=paste("Wind Slabs - Season 2016 (PM)"), Shape = "square", Percent=T)
plotHzdChartCount(HzdAssessSeason$AvProb[HzdAssessSeason$AvProb$character=="STORM_SLAB",], Title=paste("Wind Slabs - Season 2016 (PM)"), Shape = "square", Percent=T)
plotHzdChartCount(HzdAssessSeason$AvProb[HzdAssessSeason$AvProb$character=="PERSISTENT_SLAB",], Title=paste("Pers Slabs - Season 2016 (PM)"), Shape = "square", Percent=T)
plotHzdChartCount(HzdAssessSeason$AvProb[HzdAssessSeason$AvProb$character=="DEEP_PERSISTENT_SLAB",], Title=paste("Pers Slabs - Season 2016 (PM)"), Shape = "square", Percent=T)

}
