% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRunCharFreq.R
\name{plotRunCharFreq}
\alias{plotRunCharFreq}
\title{Calculate frequencies of answers.}
\usage{
plotRunCharFreq(FreqTbl, FreqTbl_Ref = NULL, plotQuestCodes,
  plotElev = c(NA, "all", "btl", "tl", "alp"), nRuns = NULL,
  color = "red", alpha = 0.4, barwidth = 0.9, plotTitle = NULL,
  plotBox = F)
}
\arguments{
\item{FreqTbl}{Frequency table with run characteristics (per SOM group or all).}

\item{FreqTbl_Ref}{Reference frequency table with run characteristics of all runs  (default=NULL).}

\item{plotQuestCodes}{Question code to be plotted.}

\item{plotElev}{Elevations to be plotted (default=c(NA, "all", "btl", "tl", "alp")).}

\item{nRuns}{Number of runs in each group (used for labeling on y-axis, default=NULL).}

\item{color}{Color for bars (default="red").}

\item{alpha}{Alpha value for transparency of bars (default=0.4).}

\item{barwidth}{Width of bars (default=0.9).}

\item{plotTitle}{Title to be plotted (default=NULL).}

\item{plotBox}{Switch for plotting a box around the plot area (default=F).}
}
\description{
Calculate frequencies of answers.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

QuestCode <- "familiarity"
RunChar <- getRecordsFromUUID(Operation, "runchar", "assessments")
QuestDef <- getRecordsFromQuery(Operation, "SELECT * FROM runchar.questions")
LineLevels <- convertArrayFromSQL(QuestDef[QuestDef$code==QuestCode,]$linelevels,Numeric=F)
ElevLevels <- convertArrayFromSQL(QuestDef[QuestDef$code==QuestCode,]$elevlevels,Numeric=F)
QuestEnum <- getRecordsFromQuery(Operation, paste0("SELECT * FROM runchar.enum_", QuestCode))
RunCharMinRelevantSkiLine <- getRunCharMinRelevantSkiLine(Operation=Operation)
QuestColNames <- getRunCharQuestColNames(QuestCode=QuestCode, Operation=Operation, AssessTblFormatted=F, ElevLevels=ElevLevels)
RunCharCompact <- RunChar[,c("uuid", "loccatskiruns_uuid","loccatskilines_uuid", QuestColNames)]
RunCharCompact <- formatRunCharAssessmentDF(Operation, RunCharCompact)

FreqTbl <- getRunCharAnswerFreqTbl(RunCharCompact, transformToMinimalLine=T, Operation=Operation, QuestCode=QuestCode, QuestDef=QuestDef, RunCharMinRelevantSkiLine=RunCharMinRelevantSkiLine, QuestEnum=QuestEnum)

plotRunCharFreq(FreqTbl=FreqTbl, plotQuestCodes=QuestCode, color="darkgreen", alpha=0.9)

}
