% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRunCharSunflower.R
\name{plotRunCharSunflower}
\alias{plotRunCharSunflower}
\title{Plots subflower plot with mean and range for ordinal run characterization variables.}
\usage{
plotRunCharSunflower(Tbl, ColChar, ColLabel = "Label", sort = NA,
  groupLines = FALSE, UserID = NA, withSunflowers = TRUE,
  vertical = FALSE, col.brewer.name = "YlOrRd",
  col.above = "#e66101", col.below = "#5e3c99",
  main = "Sunflower plot of run characteristic", xlab.show = TRUE,
  xlab = "Run/Line", ylab = paste0("Characteristic (", ColChar, ")"),
  xlab.line = 9, ylab.line = 3.5)
}
\arguments{
\item{Tbl}{Intput data frame.}

\item{sort}{Type of sorting. Options include alphabetical (NA, default), assessment mean ("mean") or assessment range ("range"), guide assessment ("guide")}

\item{groupLines}{Switch for specifying whether line classes should be grouped. Default is FALSE.}

\item{UserID}{UserId of survey participant whose assessments are plotted on top of chart}

\item{withSunflowers}{Switch for whether sunflowers shoud be added (default is T)}

\item{vertical}{Switch for turning chart vertical (Default is FALSE).}

\item{col.brewer.name}{Name of the RColorBrewer color scale. Default is 'YlOrRd'}

\item{main}{Title of plot}

\item{xlab.show}{Switch for showing xlab. default is True.}

\item{xlab}{Label of x axis}

\item{ylab}{Label of y axis}

\item{xlab.line}{Distance of x axis label to axis in number of lines as used by mtext. Default is 9}

\item{xlab.line}{Distance of y axis label to axis in number of lines as used by mtext. Default is 3.5}
}
\description{
Plots subflower plot with mean and range for ordinal run characterization variables.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Survey <- getRunCharAssessmentsSurvey("NEH")
Tbls <- convertRunCharRaw2Long(Survey)

par(mar = c(13.1,7.1,4.1,2.1))
plotRunCharSunflower(Tbl=Tbls$TblLine, ColChar = "hzd_steep")
plotRunCharSunflower(Tbl=Tbls$TblLine, ColChar = "hzd_steep", sort = "mean", col.brewer.name = "Greens")
plotRunCharSunflower(Tbl=Tbls$TblLine, ColChar = "hzd_steep", sort = "range", col.brewer.name = "Blues")

## Plots assessments of user 2 on top
plotRunCharSunflower(Tbl=Tbls$TblLine, ColChar = "hzd_steep", sort = "mean", col.brewer.name = "Blues", UserID = 2)
plotRunCharSunflower(Tbl=Tbls$TblLine, ColChar = "hzd_steep", sort = "guide", col.brewer.name = "Blues", UserID = 2)

}
