% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRunCharSunflowerMultiple.R
\name{plotRunCharSunflowerMultiple}
\alias{plotRunCharSunflowerMultiple}
\title{Plots subflower plot with mean and range for ordinal run characterization variables.}
\usage{
plotRunCharSunflowerMultiple(Tbl, ColChar, ColLabel = "Label",
  sort = NA, YesPercForConcensus = 50, withSunflowers = TRUE,
  col.brewer.name = "YlOrRd",
  main = "Sunflower plot of run characteristic", xlab.show = TRUE,
  xlab = "Run/Line", ylab = paste0("Characteristic (", ColChar, ")"),
  xlab.line = 9, ylab.line = 3.5, DotSizeMin = 0.5,
  DotSizeMax = 2.5)
}
\arguments{
\item{Tbl}{Intput data frame.}

\item{sort}{Type of sorting. Options include alphabetical (NA, default), assessment mean ("mean") or assessment range ("range"), guide assessment ("guide")}

\item{YesPercForConcensus}{Percentage of yes answers for general question that is considered a concensus. Default is 50.}

\item{withSunflowers}{Switch for whether sunflowers shoud be added. Default is T.}

\item{col.brewer.name}{Name of the RColorBrewer color scale. Default is 'YlOrRd'}

\item{main}{Title of plot}

\item{xlab.show}{Switch for showing xlab. default is True.}

\item{xlab}{Label of x axis}

\item{ylab}{Label of y axis}

\item{xlab.line}{Distance of x axis label to axis in number of lines as used by mtext. Default is 9.}

\item{DotSizeMin}{Mimimum dot size. Default is 0.5.}

\item{DotSizeMax}{Maximum dot size. Default is 2.5.}

\item{UserID}{UserId of survey participant whose assessments are plotted on top of chart (NOT IMPLEMENTED!).}

\item{xlab.line}{Distance of y axis label to axis in number of lines as used by mtext. Default is 3.5.}
}
\description{
Plots subflower plot with mean and range for ordinal run characterization variables.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Survey <- getRunCharAssessmentsSurvey("NEH")
Tbls <- convertRunCharRaw2Long(Survey)

par(mar = c(13.1,7.1,4.1,2.1))
## Terrain hazard
plotRunCharSunflowerMultiple(Tbl = Tbls$TblLine,
                             ColChar = "hzd_terrainhzd",
                             ylab.line = 5,
                             col.brewer.name = "Greens")

plotRunCharSunflowerMultiple(Tbl = Tbls$TblLine,
                             ColChar = "hzd_terrainhzd",
                             ylab.line = 5,
                             col.brewer.name = "Greens",
                             sort = "mean")

plotRunCharSunflowerMultiple(Tbl = Tbls$TblLine,
                             ColChar = "hzd_terrainhzd",
                             ylab.line = 5,
                             col.brewer.name = "Greens",
                             sort = "largeoh")

plotRunCharSunflowerMultiple(Tbl = Tbls$TblLine,
                             ColChar = "hzd_terrainhzd",
                             ylab.line = 5,
                             col.brewer.name = "Greens",
                             sort = "largeoh", 
                             YesPercForConcensus = 75)

## Operational role
plotRunCharSunflowerMultiple(Tbl = Tbls$TblLine,
                             ColChar = "use_oprole",
                             ylab.line = 5,
                             col.brewer.name = "Blues",
                             sort = "mean")

plotRunCharSunflowerMultiple(Tbl = Tbls$TblLine,
                             ColChar = "use_oprole",
                             ylab.line = 5,
                             col.brewer.name = "Blues",
                             sort = "bread")

}
