% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printRunCharAssessments.R
\name{printRunCharAssessments}
\alias{printRunCharAssessments}
\title{Get run character assessments}
\usage{
printRunCharAssessments(RunChar, TitleAddition = NA, ShowCons = T,
  ShowTyp = T, ShowAggr = T, ShowFam = T, ShowConflict = T,
  ShowAccess = T, ShowSkiExp = T, ShowUsab = T, ShowHzd = T,
  ShowMitig = T)
}
\arguments{
\item{RunChar}{Run character assessment data frame}

\item{ShowCons}{Switch for showing assessment of most conervative line(s). Default is TRUE.}

\item{ShowTyp}{Switch for showing assessment of typical line(s). Default is TRUE.}

\item{ShowAggr}{Switch for showing assessment of more aggressive line(s). Default is TRUE.}

\item{ShowFam}{Switch for showing familiarity section. Default is TRUE.}

\item{ShowAccess}{Switch for showing access section. Default is TRUE.}

\item{ShowSkiExp}{Switch for showing skiing experience section. Default is TRUE.}

\item{ShowUsab}{Switch for showing usability section. Default is TRUE.}

\item{ShowHzd}{Switch for showing hazard potential section. Default is TRUE.}

\item{ShowMitig}{Switch for showing hazard mitigation section. Default is TRUE.}
}
\description{
Get run character assessments
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "CMHGL"

## Single run
SkirunNames <- c("Alexis")
RunChar <- getRunCharAssessments(Operation, SkirunNames=SkirunNames)
printRunCharAssessments(RunChar)

## Most conservative lines on runs of Wagner Blows cluster
ClusterNames <- "Wagner Bowls"
RunChar <- getRunCharAssessments(Operation, ClusterNames=ClusterNames)
printRunCharAssessments(RunChar, ShowTyp=F, ShowAggr=F, TitleAddition = "Cluster: Wanger Bowls")

## All assessments
RunChar <- getRunCharAssessments(Operation)
printRunCharAssessments(RunChar, ShowTyp=F, ShowAggr=F, TitleAddition = "All runs on Nov. 26, 2017")
}
