% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processGPSTracks.R
\name{processGPSTracks}
\alias{processGPSTracks}
\title{Processes GPS tracks}
\usage{
processGPSTracks(Operation, Folder_GPSTracks, Folder_OutputRoot,
  DBType = "Main", UseElevRaster = T, ElevRaster = NA,
  FileNameThirdPart = "guide", DefaultGuideType = "Lead guide",
  WriteToDB = T, WriteChartsToFile = T,
  OnlyProcessTrackdaysNotInDB = F, Process_TrackFileNames = NA,
  Process_FirstTrackIndex = 1, Process_TrackdayDates = NA,
  NeedToDownSampleGPSTrack = T, TargetRecordingInterval = 4,
  InclRunUseList = T, InclRunUseListFromPrevProcTrackdays = F,
  TimeDiffGMT = 8, MinNumObsInsideOpAreaForProcessing = 10,
  DilutionThreshold = 6, GPSSpatialAccuracy = 4, OpArea_Buffer = 500,
  Flight_MinSpeed = 60, Flight_MinDuration = 20,
  Flight_MinAltGain = 100, CatRoad_MaxDist = 20,
  CatRoad_MinDist = 200, CatRoad_MinDuration = 60,
  CatRoad_MaxPercentageOfRun = 0.85, Pause_MinTime = 10,
  Pause_MoveMinTime = 10, Pause_DistRadius = 5, Break_MinTime = 90,
  Break_MoveMinTime = 10, Break_DistRadius = 15,
  UpDown_AltDiffThreshold = 50, UpDown_MinDuration = 20,
  UpDown_StartEndAltBuffer = 25,
  NewRun_DistToPrevObsWithInclReq_Dist = 500,
  NewRun_DistToPrevObsWithInclReq_Incl = 15,
  NewRun_AltDiffToPrevObs = 100,
  NewRun_DistToPrevObsWithoutInclReq = 1500, PotRun_MinDuration = 120,
  PotRun_MinDurationSkiing = 40, PotRun_ShowProcessingDetail = F,
  Run_MinLength = 200, Run_MinMaxSkiingSpeed = 10,
  Simplify_RemoveBightMaxDist = 10,
  Simplify_ForcePausePointsReplaceDist = 10,
  Simplify_SimplifyThreshold = NA, Col_GettingReady = "brown",
  Col_PackingUp = "dark green", Col_Pause = "steelblue1",
  Col_Break = "royalblue3", Col_Skiing = "sienna1",
  Col_CatRiding = "beige", Col_Flying = "palegreen2",
  Col_Outside = "grey", Chart_Width = 900, Chart_Height = 600)
}
\arguments{
\item{Operation}{Name of Operation. Used for accessing PostgreSQL/PostGIS GPS database.}

\item{Folder_GPSTracks}{Complete path of folder with GPS to be processed. You can use function paste0(getLocalRootFolderPath(Operation, User), "WhateverSubFolderPathYouWant") to make script transferable between users.}

\item{Folder_OutputRoot}{Complete path of local root folder for processing output.}

\item{DBType}{Type of database the records should be written to. Can be 'Main' (default) or 'NodeJS' for database that feeds online viewer.}

\item{UseElevRaster}{Flag whether elevation values from raster are used to determine uphill and downhill sections of GPS tracks. Typically produces better results than the altitude values from the GPS units.}

\item{ElevRaster}{Elevation raster of class RasterLayer. Required if UseElevRaster==TRUE. You can use getRaster(Operation, User, "Elevation") function for retrieving elevation raster.}

\item{FileNameThirdPart}{Specifies what the thirs part of the file name of the GPS tracks means. Possible values include 'guide' (default), 'program' or NA.}

\item{DefaultGuideType}{Specifies default entry for guide type field in tracks_day table (e.g., 'Lead guide' (default), Snowsafety, ...).}

\item{WriteToDB}{Flag for specifying whether the results of the processing should be written to the PostgreSQL/PostGIS GPS database (TRUE, default) or to CSV file (FALSE). To avoid the processing of the same GPS data multiple times, only trackdays are processed that do not yet have any records in the database. Partially processed trackdays need to be deleted before they can be reprocessed again. Use deleteTrackdayRecordsPostgreSQL() to delete trackday from database.}

\item{WriteChartsToFile}{Flag for specifying whether charts should be written to png file (default) or presented in a window in R.}

\item{OnlyProcessTrackdaysNotInDB}{Flag for specifying whether only trackdays that have not been written to database previously should be processed. Only applies when output is written to CSV file (i.e., WriteToDB==F), since it is impossible to write a trackday multiple time to the database. Default value is FALSE.}

\item{Process_TrackFileNames}{Single file name or list of file names of GPS tracks in Folder_GPSTracks to be processed. By default, all CSV files in Folder_GPSTracks are processed.}

\item{Process_FirstTrackIndex}{Index of first GPS track file in Folder_GPSTracks to be processed. This parameter allows the efficient skipping of files that might have been processed previously. Default values is 1, which means that all files are processed. If parameter Process_TrackFileNames is used, Process_FirstTrackIndex must be smaller or equal to the number of file names provided in Process_TrackFileNames.}

\item{Process_TrackdayDates}{Single date or list of dates for which GPS tracks should be processed. By default all of the dates included in the GPS track files are processed.}

\item{NeedToDownSampleGPSTrack}{Flag specifying whether the recording frequency of the GPS track needs to be checked and potentially downsampled to the trget interval specified with the parameter TargetRecordingInterval. Only works if the TargetRecordingInterval is a multiple of the existing recording interval (e.g., GPS track has records very 2 sec, but the target interval is 4 sec).}

\item{TargetRecordingInterval}{Target recording interval for GPS tracks. Default value is 4 sec, which has been used in most GPS tracks.}

\item{InclRunUseList}{Flag for specifying whether run use lists of processed trackdays should be included. Default is TRUE.}

\item{InclRunUseListFromPrevProcTrackdays}{Flag for specifying whether run use lists of previously processed trackdays should be included in the output file. Default value is FALSE to reduce processing time and the size of the output file.}

\item{TimeDiffGMT}{Constant for time difference from GMT (time recorded with GPS observations) to local time. Default is 8 hrs (GMT to PST)}

\item{MinNumObsInsideOpAreaForProcessing}{Minimum number of observations inside of operating area required for a day to be processed. Default value is 10.}

\item{DilutionThreshold}{Constant for minimun dilution value for GPS observations to be excluded from analysis. Default value is 6 (see Sigrist et al. (1999))}

\item{GPSSpatialAccuracy}{Constant for known spatial accuracy of GPS observations in meters. Default value is 4 m (Rupf et al., 2010). This parameter is currently not used for any computations.}

\item{OpArea_Buffer}{Constant for buffer distance around operating area in meters. GPS observations are only processed if they are within the buffer distance of the operating area. The buffer ensures that runs that are at the boundary of the operating area are processed even if the accuracy of the operation area boundary polygon is limited. Default value is 500 m.}

\item{Flight_MinSpeed}{Constant for minimum speed that is considered to be associated with flying in a helicopter in km/h.  Default value is 60 km/h. This value is used to identify helicopter flight in GPS tracks from heliskiing.}

\item{Flight_MinDuration}{Constant for minimum duration of a helicopter flight in seconds. Default value is 20 sec. Shorter periods with speeds above Flight_MinSpeed are not marked as flights.}

\item{Flight_MinAltGain}{Constant for minimum elevation gain for a potential flight segment to be considered a flight in m. Default value is 100 m. The required elevation gain is between the beginning and end of the segment (start to end location). This requirements is not applied to the last flight of the day, which might be going straight into the valley.}

\item{CatRoad_MaxDist}{Constant for maximum distance of GPS observation to cat road stored in PostgreSQL/PostGIS GPS database to be considered on road in m. Defaults value is 20 m.}

\item{CatRoad_MinDist}{Constant for minimum distance of continuous car road ride. Default value is 200m.}

\item{CatRoad_MinDuration}{Constant for minimum duration on cat road for potentially being considered riding a snowcat in sec. Default value is 60 sec.}

\item{CatRoad_MaxPercentageOfRun}{Maximum percentage of observations that can be on a cat road for ski run not considered a cat ride. Default of 0.8.}

\item{Pause_MinTime}{Constant for minimum duration of shorter pause periods in sec. Value needs to be smaller than Break_MinTime. Default value is 10 sec.}

\item{Pause_MoveMinTime}{Constant for minimum duration of moving period between shorter pause periods. Default value is 10 sec. This value needs to be equal or smaller than the value of Pause_MinTime.}

\item{Pause_DistRadius}{Constant for maximum travel distance during shorter pause periods in m. Value needs to be smaller than Break_DistRadius. Default value is 5 m.}

\item{Break_MinTime}{Constant for minimum duration of a longer break period (e.g., getting ready at beginning of run, packing up at end of run, longer breaks duriong run...) in sec. Value needs to be larger than Pause_MinTime. Default value is 90 sec.}

\item{Break_MoveMinTime}{Constant for minimum duration of moving period between break periods. Default value is 10 sec. This value needs to be equal or smaller than the value of Break_MinTime.}

\item{Break_DistRadius}{Constant for maximum travel distance during a break in m. Value needs to be larger than Pause_DistRadius. Default value is 15 m.}

\item{UpDown_AltDiffThreshold}{Constant for altitude difference threshold in m that will trigger the switch from an uphill to a downhill section or vice versa. Default value is 50 m.}

\item{UpDown_MinDuration}{Constant for minimum duration of up-or downhill section in sec. Default value is 20 sec.}

\item{UpDown_StartEndAltBuffer}{Constant for elevation metre buffer for GPS observation still to be considered part of a downhill section in m. Default value is 25 m. This means that GPS observations prior to a true downhill section that are less than 25 m lower than the absolute high point of the downhill section are still included in the extraction of a potential ski run.}

\item{NewRun_DistToPrevObsWithInclReq_Dist}{Constant for minimum distance between GPS observations that would trigger the marking of the start of a potential new ski run with the additional altitude change requirement in m. Default value is 500 m.}

\item{NewRun_DistToPrevObsWithInclReq_Incl}{Maximum average incline requirement for distances between NewRun_DistToPrevObsWithInclReq_Dist and NewRun_DistToPrevObsWithoutInclReq to trigger a new start/end of a run in degrees.Default is 15 deg.}

\item{NewRun_AltDiffToPrevObs}{Constant for minimum altitude difference between GPS observations that would trigger the marking of the start of a potential new ski run in m. Default value is 100 m.}

\item{NewRun_DistToPrevObsWithoutInclReq}{Constant for minimum distance between GPS observations that would trigger the marking of the start of a potential new ski run without the additional altitude change requirement in m. Default value is 1500 m.}

\item{PotRun_MinDuration}{Constant for minimum duration of potential ski run in sec. Default value is 120 sec.}

\item{PotRun_MinDurationSkiing}{Constant for minimum duration of skiing during potential ski run in sec. Default value is 40 sec.}

\item{PotRun_ShowProcessingDetail}{Switch for showing or hiding detailed output during processing of potential runs. Default is F.}

\item{Run_MinLength}{Constant for minimum length of ski run in m. Default value is 200 m.}

\item{Run_MinMaxSkiingSpeed}{Constant for minimum value of maximum skiing speed during ski run in km/h. Default value is 10 km/h.}

\item{Simplify_RemoveBightMaxDist}{Constant for maximum distance in m within a bight in a ski run line for the bight to be removed. Default value is 10 m. Set parameter to NA for bights not to be removed.}

\item{Simplify_ForcePausePointsReplaceDist}{Constant for minimum distance for forcing the ski line through a pause or break point. Default value is 10 m.  Set parameter to NA for not forcing line through pause points.}

\item{Simplify_SimplifyThreshold}{Constant for distance value in m used to simplify run line geometry using rgeos:gsimplfy. The value is the numerical tolerance to be used by the Douglas-Peuker algorithm. See description of gsimplify for more detail. Default is NA, which means that the ski run lines are not being simplfied.}

\item{Col_GettingReady}{Standard color for 'getting ready' break points. Default value is brown.}

\item{Col_PackingUp}{Standard color for 'packing up' break points. Default value is dark green.}

\item{Col_Pause}{Standard color for pause points. Default value is steelblue1.}

\item{Col_Break}{Standard color for break points. Default value is royalblue3.}

\item{Col_Skiing}{Standard color for skiing points. Default value is sienna1.}

\item{Col_CatRiding}{Standard color for snowcat riding points. Default value is beige.}

\item{Col_Flying}{Standard color for flying points. Default value is palegreen2.}

\item{Col_Outside}{Standard color got points outside of the operating area or inside an exclusion polygon. Default value is grey.}

\item{Chart_Width}{Costant for width of png output charts.}

\item{Chart_Height}{Constant for height of png output charts.}
}
\value{
Dataframe with basic processing summary
}
\description{
Processes GPS tracks and imports results into PostgreSQL/PostGIS GPS database or writes them out as CSV files. Produces various additional output files (cvs, txt and png).
}
