% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectRunCharAssessQuestion.R
\name{selectRunCharAssessQuestion}
\alias{selectRunCharAssessQuestion}
\title{Select specific question columns of run characterization table.}
\usage{
selectRunCharAssessQuestion(RunCharAssessFormatted, QuestCode, Operation,
  ElevLevels = c("all", "alp", "tl", "btl"))
}
\arguments{
\item{RunCharAssessFormatted}{Formated data frame.}

\item{QuestCode}{Code for question.}
}
\value{
Formatted dataframe.
}
\description{
Select specific question columns of run characterization table.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "NEH"
RunCharAssess <- getRecordsFromQuery(Operation, "SELECT * FROM runchar.assessments")

RunCharAssessFormatted <- formatRunCharAssessmentDF(Operation, RunCharAssess)

## GET QUESTION DEFINITION TABLE FOR QUESTION CODES
QuestDef <- getRecordsFromQuery(Operation, "SELECT * FROM runchar.questions")

QuestCode <- "familiarity"
RunCharAssessQuestion <- selectRunCharAssessQuestion(RunCharAssessFormatted, QuestCode, Operation=Operation)
}
