% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendQueryToGPSDB.R
\name{sendQueryToGPSDB}
\alias{sendQueryToGPSDB}
\title{Send SQL query to PostgreSQL/PostGIS GPS database.}
\usage{
sendQueryToGPSDB(Operation, Query, DBType = "Main", Verbose = F,
  SuppressPostgreSQLWarnings = T, MaxNumTries = 10)
}
\arguments{
\item{Operation}{Name of operation for accessing correct database.}

\item{Query}{SQL query.}

\item{DBType}{Type of database to send the query to. Can be 'Main' (default) or 'NodeJS' for database that feeds online viewer}

\item{Verbose}{Switch for printing SQL query. Default value is FALSE.}

\item{SuppressPostgreSQLWarnings}{Switch for turning warnings off. Default value is TRUE.}

\item{MaxNumTries}{Number of maximum tries that are attempted. Default value is 10.}
}
\description{
Send SQL query that does not produce any result (e.g., delete query, insert query, ...) to PostgreSQL/PostGIS GPS database. IMPORTANT: Only use for single queries or short loops. Long loops are much faster if the Db connection is established once and all records are submitted together. See writeDFToGPSDB for example.
}
