% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setStdRunlistCode.R
\name{setStdRunlistCode}
\alias{setStdRunlistCode}
\title{Function for linking a standard runlist code to an operation-specific code}
\usage{
setStdRunlistCode(Operation, OpCode, StdCode = tolower(OpCode),
  DBType = "Main")
}
\arguments{
\item{Operation}{Name of operation for accessing correct database.}

\item{OpCode}{Name of operation code}

\item{StdCode}{Name of equivalent standard code. By default it is the OpCode in lower case.}

\item{DBType}{Type of database to send the query to. Can be 'Main' (default) or 'NodeJS' for database that feeds online viewer}
}
\description{
Function for linking a standard runlist code to an operation-specific code. Function checks for correct values, but overwrites values without warning message.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "CMHGL"

OpCode <- "pink"
setStdRunlistCode(Operation, OpCode)

OpCode <- "red"
StdCode <- "pink"
setStdRunlistCode(Operation, OpCode, StdCode)

OpCode <- "red"
StdCode <- "red"
setStdRunlistCode(Operation, OpCode)

OpCode <- "red"
setStdRunlistCode(Operation)
}
