% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateGPSRuns2LoccatLink.R
\name{updateGPSRuns2LoccatLink}
\alias{updateGPSRuns2LoccatLink}
\title{Determines closest skilines and ski runs and updates link in database in gps.runs table.}
\usage{
updateGPSRuns2LoccatLink(Operation, GpsUnit = NULL, DateStart,
  DateEnd = DateStart, SkiLinesMaxDist = 500, SkiRunMinDist = 500,
  DBType = "Main", QCOnly = T, Verbose = F, ShowProgress = T,
  UserConfirm = T)
}
\arguments{
\item{Operation}{Name of operation.}

\item{GpsUnit}{Name of GPS unit.}

\item{DateStart}{Starting date of date range.}

\item{DateEnd}{End date of date range (equal to DateStart by default).}

\item{SkiLinesMaxDist}{Maximum average distance between start/end point of track and ski line for the ski line to be considered for naming the track.}

\item{SkiRunMinDist}{Minimum length of GPS track within a ski run polygon for the ski run to be considered for naming the track.}

\item{DBType}{Operational parameter for specifying from which database the run uuids should be retrieved. Values can be 'Main' (default) or 'NodeJS'.}

\item{QCOnly}{Switch for only including quality controlled runs.}

\item{Verbose}{Switch for printing of query}

\item{UserConfirm}{Switch whether user needs to confirm before records in database are overwritten. Default is T.}
}
\description{
Determines closest skilines and ski runs and updates link in database in gps.runs table. If these are multipe run/lines that are closest, the first one is taken. CAUTION: THIS FUNCTION OVERWRITES ALL EXISTING RECORDS IN DB!
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "MPS"

updateGPSRuns2LoccatLink(Operation, DateStart = "2015-10-01", DateEnd = "2016-05-01")

}
