% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateStoredRasterCoordGPSRuns.R
\name{updateStoredRasterCoordGPSRuns}
\alias{updateStoredRasterCoordGPSRuns}
\title{Update coordinates of raster cells along ski runs stored in Postgres/PostGIS GPS database.}
\usage{
updateStoredRasterCoordGPSRuns(Operation, User = "SARPLab",
  RasterName = "Incline", BufferDist = c(0, 20, 40, 60),
  DecimalDigitsForCoordinates = 5, OnlyQCRuns = T, Overwrite = F,
  UserConfirm = T, Test = F, Verbose = F,
  SuppressPostgreSQLWarnings = T)
}
\arguments{
\item{Operation}{Name of operation}

\item{User}{Name of user. Required for local root folder for location of raster. Default value is 'SARPLab'.}

\item{RasterName}{Name of raster for extraction of coodinates. Default is Incline}

\item{BufferDist}{size of buffer around GPS ski run in metres. Default value array of 0, 20, 40 & 60 m.}

\item{DecimalDigitsForCoordinates}{Decimal digits for extracted values. Default value is 5.}

\item{OnlyQCRuns}{Switch to specify whether to process only runs that are quality controlled (default) or all runs. Default value is TRUE}

\item{Overwrite}{Switch to specify whether to erase all records from the table before (re-) processing the runs. Default value id FALSE.}

\item{UserConfirm}{Flag whether the user needs to actively confirm deletion. True by default.}

\item{Test}{Only the first 10 runs are processed in Test mode. Default value is FALSE.}

\item{Verbose}{Switch for printing of query. Default value is FALSE.}

\item{SuppressPostgreSQLWarnings}{Switch for turning warnings off. Default value is TRUE.}
}
\description{
Update coordinates of raster cells along ski runs stored in Postgres/PostGIS GPS database.
}
