% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateStoredRasterCoordLoccatSkiruns.R
\name{updateStoredRasterCoordLoccatSkiruns}
\alias{updateStoredRasterCoordLoccatSkiruns}
\title{Update coordinates of raster cells within skirun polygon from location catalog stored in Postgres/PostGIS GPS database.}
\usage{
updateStoredRasterCoordLoccatSkiruns(Operation, User = "SARPLab",
  RasterName = "Incline", BufferDist = c(-60, -40, -20, 0),
  DecimalDigitsForCoordinates = 5, Overwrite = F, UserConfirm = T,
  Test = F, Verbose = F, SuppressPostgreSQLWarnings = T)
}
\arguments{
\item{Operation}{Name of operation}

\item{User}{Name of user. Required for local root folder for location of raster. Default value is 'SARPLab'}

\item{RasterName}{Name of raster for extraction of coodinates. Default is Incline}

\item{BufferDist}{size of buffer around GPS ski run in metres. Default value array of -60, -40, -20 & 0 m.}

\item{DecimalDigitsForCoordinates}{Decimal digits for extracted values. Default value is 5.}

\item{Overwrite}{Switch to specify whether to erase all records from the table before (re-) processing the runs. Default value id FALSE.}

\item{UserConfirm}{Flag whether the user needs to actively confirm deletion. True by default.}

\item{Test}{Only the first 10 runs are processed in Test mode. Default value is FALSE.}

\item{Verbose}{Switch for printing of query. Default value is FALSE.}

\item{SuppressPostgreSQLWarnings}{Switch for turning warnings off. Default value is TRUE.}
}
\description{
Update coordinates of raster cells within skirun polygon from location catalog stored in Postgres/PostGIS GPS database.
}
