% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateStoredRasterValuesGPSRuns.R
\name{updateStoredRasterValuesGPSRuns}
\alias{updateStoredRasterValuesGPSRuns}
\title{Extract values from raster along ski runs}
\usage{
updateStoredRasterValuesGPSRuns(Operation, RasterNames, User = "SARPLab",
  Method = "simple", DecimalDigits = 0, Overwrite = F, Test = F,
  UserConfirm = T, Verbose = F, SuppressPostgreSQLWarnings = T)
}
\arguments{
\item{Operation}{Name of operation}

\item{RasterNames}{Name of raster(s) to be processed. Can be single string or array of strings.}

\item{User}{Name of user. Required for local root folder for location of raster. Default value is 'SARPLab'.}

\item{Method}{Method for extraction of raster values. Must be 'simple' or 'bilinear'. See help for raster::extract for more detail.}

\item{DecimalDigits}{Decimal digits for extracted values. Default value is 0 (zero). Can be single number of array of numbers. If an array, it needs to be os same size as RasterNames.}

\item{Overwrite}{Switch to specify whether to erase all records from the table before (re-) processing the runs. Default value id FALSE.}

\item{Test}{Only the first 10 runs are processed in Test mode. Default value is FALSE.}

\item{UserConfirm}{Flag whether the user needs to actively confirm deletion. True by default.}

\item{Verbose}{Switch for printing of query. Default value is FALSE.}

\item{SuppressPostgreSQLWarnings}{Switch for turning warnings off. Default value is TRUE.}
}
\description{
Extract values from raster within a given buffer along GPS ski runs and stores them in PostgreSQL/PostGIS GPS database.
}
