% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateTblInGPSDB.R
\name{updateTblInGPSDB}
\alias{updateTblInGPSDB}
\title{Write spatial dataframe to prexisting table in PostgreSQL/PostGIS GPS database}
\usage{
updateTblInGPSDB(DF, Operation, Schema, DBTbl, DBType = "Main",
  DBTblHist = paste0(DBTbl, "_h"), WriteToHistTbl = T, Verbose = F,
  SuppressPostgreSQLWarnings = T, ShowCounter = 1, ObjLabel = "row")
}
\arguments{
\item{DF}{Dataframe}

\item{Operation}{Name of operation}

\item{Schema}{Name of database schema that contains database table}

\item{DBTbl}{Name of database table with geometry}

\item{DBType}{Type of database: "Main" (default) or "NodeJS".}

\item{DBTblHist}{Name of database table that stores history information}

\item{WriteToHistTbl}{Boolean flag for whether the original record should first be written to a history table.}

\item{Verbose}{Switch for printing of query}

\item{SuppressPostgreSQLWarnings}{Switch for supressing warning messages from postgresqlExecStatement. Default value is TRUE. Turn on for debugging!}

\item{ShowCounter}{Numeric value that specifies whether counter for queries should be shown (>0) and at what interval}

\item{ObjLabel}{Label for making process counter more meaningful.}
}
\description{
Writes entire content of spatial dataframe to prexisting table in PostgreSQL/PostGIS GPS database. All of the columns of the spatial dataframe need to exist in the database table.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Oper <- "NEH"

## Retrieving existing records
Tbl_Flying <- getRecordsFromUUID(Oper, "obs", "cond_flying")

## Modifying set of existing records
Tbl_FlyingToEdit <- Tbl_Flying[c(1:10), c("uuid", "comment")]
Tbl_FlyingToEdit$comment <- paste("TEST", c(1:10))

## Updating modified records in database
updateTblInGPSDB(Tbl_FlyingToEdit, Oper, "obs", "cond_flying")

## Checking updated records
Tbl_Flying_Updated <- getRecordsFromUUID(Oper, "obs", "cond_flying", UUID=Tbl_FlyingToEdit$uuid)

## Checking complete history on updated records
Tbl_Flying_History <- getRecordsFromUUID(Oper, "obs", "cond_flying_h", UUID=Tbl_FlyingToEdit$uuid, AddRowNames=F)

}
