% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeSPDFToGPSDB.R
\name{writeSPDFToGPSDB}
\alias{writeSPDFToGPSDB}
\title{Write spatial dataframe to prexisting table in PostgreSQL/PostGIS GPS database.}
\usage{
writeSPDFToGPSDB(SPDF, Operation, Schema, DBTbl, DBType = "Main",
  GeomCol = "geom", SRID = 4617, Overwrite = F,
  Polygon2Multipolygon = F, Verbose = F,
  SuppressPostgreSQLWarnings = T, ShowCounter = 1, ObjLabel = "row",
  MaxNumTries = 10)
}
\arguments{
\item{SPDF}{Spatial dataframe}

\item{Operation}{Name of operation}

\item{Schema}{Name of database schema that contains database table}

\item{DBTbl}{Name of database table with geometry}

\item{DBType}{Type of database the table should be written to. Can be 'Main' (default) or 'NodeJS' for database that feeds online viewer.}

\item{GeomCol}{Name of geometry column in database table}

\item{SRID}{Numeric reference to coordinate system for geospatial information}

\item{Overwrite}{Boolean flag for whether the entire table should be overwritten (i.e., all records deleted first)}

\item{Polygon2Multipolygon}{Boolean flag for indicating whether a polygon layer needs to be converted into a multipolygon layer}

\item{Verbose}{Switch for printing of query}

\item{SuppressPostgreSQLWarnings}{Switch for supressing warning messages from postgresqlExecStatement. Default value is TRUE. Turn on for debugging!}

\item{ShowCounter}{Numeric value that specifies whether counter for queries should be shown (>0) and at what interval}

\item{ObjLabel}{Label for making process counter more meaningful.}

\item{MaxNumTries}{Number of maximum tries that are attempted. Default value is 10.}
}
\description{
Writes entire content of spatial dataframe to prexisting table in PostgreSQL/PostGIS GPS database. All of the columns of the spatial dataframe need to exist in the database table.
}
