## ***********************************
## Adding data to package SarpGPSTools
## ***********************************

## Operation codes for all databases on the Windows server (Main)
## **************************************************************

Operations_MainDB <- c("CMHAD", "CMHBB", "CMHBU", "CMHCA", "CMHGL", "CMHGO", "CMHK2", "CMHMO", "CMHRE", "CMHVA",
                       "MPS", 
                       "MWHS",
                       "NEH",
                       "STHS",
                       "WHS")

devtools::use_data(Operations_MainDB, overwrite=T)


## Operation codes for all databases on the Linux server (NodeJS)
## **************************************************************

Operations_NodeJSDB <- c("CMHGL", "CMHRE",
                       "MPS", 
                       "MWHS",
                       "NEH",
                       "STHS",
                       "WHS")

devtools::use_data(Operations_NodeJSDB, overwrite=T)


## Operation codes for all CMH Operations
## **************************************

Operations_CMH <- c("CMHAD", "CMHBB", "CMHBU", "CMHCA", "CMHGL", "CMHGO", "CMHK2", "CMHMO", "CMHRE", "CMHVA")

devtools::use_data(Operations_CMH, overwrite=T)


## Operation codes for all databases on the Linux server (NodeJS)
## **************************************************************

SOMTypes_Supported <- c("skirunsskilines", "runlists", "runusereportsdaily", "runusegpstracksdaily")

devtools::use_data(SOMTypes_Supported, overwrite=T)


## Global coordinate system specifications
## ***************************************
Const_GlobalCrsSrid <- 4617
Const_GlobalCrsString <- "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs"

devtools::use_data(Const_GlobalCrsSrid, overwrite=T)
devtools::use_data(Const_GlobalCrsString, overwrite=T)


## ListAvProblemTypes
## ******************

AvProblemTypes <- data.frame(Label = c("Deep Persistent Slabs", "Persistent Slabs", "Storm Slabs", "Wind Slabs", "Cornices", "Loose Dry", "Wet Slabs", "Loose Wet", "Glide"),
                             InfoEx = c("DEEP_PERSISTENT_SLAB", "PERSISTENT_SLAB", "STORM_SLAB", "WIND_SLAB", "CORNICE", "LOOSE_DRY_AVALANCHE", "WET_SLAB", "LOOSE_WET_AVALANCHE", "GLIDE"))
                             
devtools::use_data(AvProblemTypes, overwrite=T)
                             
                             
                             


