require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Oper <- "WHS"

## Load raster
DEM_Raw <- raster("C:/Temp/dem3/50n150w_20101117_gmted_mea075.tif")

## Load location catalog
LocCat <- getLocCatlog(Oper, LocalProjection = F) 

## Plot operating area
plot(LocCat$OpArea)
LocCat$OpArea

## Specify extent for cropping dem
extent <- c(-123.7, -121.8, 50, 50.9)
DEM <- crop(DEM_Raw, extent)

## Plot dem to check
plot(DEM)
plot(LocCat$OpArea, add=T)

## Check terrain coloring
plot(LocCat$OpArea)
plotTerrain(DEM, add=T)
plot(LocCat$OpArea, add=T)

## Save file
save(DEM, file=paste0("C:/Temp/gmted_mea075_", Oper, ".rda"), compress = TRUE)
writeRaster(DEM, file=paste0("C:/Temp/gmted_mea075_", Oper, ".tif"))
