#' Function for adding vertical grid lines and date axis to chart
#'
#' Function for adding vertical grid lines and date axis to chart.
#' @param DateArray Date array.
#' @param WithXAxis Switch for plotting the x-axis (default=TRUE).
#' @param HighlightDateStart Array with starts of highlighted time period (default=NA).
#' @param HighlightDateEnd Array with ends of highlighted time period (default=HighlightDateStart).
#' @param HighlightCol Array with colors for highlighted time period (default="light grey").
#' @param cex.axis cex.axis (default=1.0).
#' @param cex.lab cex.lab (default=1.0).
#' @export

addTimeGridAndHighlight <- function(DateArray,
                                    WithXAxis=T,
                                    HighlightDateStart=NA,
                                    HighlightDateEnd=HighlightDateStart,
                                    HighlightCol="light grey",
                                    cex.axis=1.0,
                                    cex.lab=1.0) {

  ## Create axis
  DateArray <- seq(from=as.Date(min(DateArray)), to=as.Date(max(DateArray)), by="days")
  Saturdays <- DateArray[weekdays(DateArray)=="Saturday"]
  if(WithXAxis) {
    axis(1, at=Saturdays, labels=format(Saturdays, "%m/%d"), cex.axis=cex.axis)
  }

  ## Expand HighlightCol is necessary
  if(length(HighlightDateStart) > 1 & length(HighlightCol)==1){
    HighlightCol <- rep(HighlightCol, times=length(HighlightDateStart))
  }

  ## Add Highlighted areas
  if(all(!is.na(HighlightDateStart))) {
    HighlightDateStart <- as.Date(HighlightDateStart)
    HighlightDateEnd   <- as.Date(HighlightDateEnd)
    for (i in 1:length(HighlightDateStart)){
      rect(HighlightDateStart[i]-0.5,-1000, HighlightDateEnd[i]+0.5, 1000, col=HighlightCol[i], border=NA)
    }
  }

  ## Vertical gridlines
  abline(v=Saturdays, lty=3, col="dark grey")
  box()

}
