#' Gets 1km DEM for British Columbia and Alberta
#'
#' Gets 1km DEM for British Columbia and Alberta. This the USGS 30 arc-second Elevation (GTopo30) cropped and preprocessed for British Columbia and Alberta.
#' The data is stored at http://data.avalancheresearch.ca/gmted_mea300_BCAB.rda.
#' See https://lta.cr.usgs.gov/GTOPO30 for more information on GTOPO30.
#'
#' @examples
#' require(SarpGeneralVis)
#'
#' DEM <- getDEM_BCAB()
#' plot(DEM)
#'
#' @export

getDEM_BCAB <- function() {

  ## Load data
  load(url("http://data.avalancheresearch.ca/gmted_mea300_BCAB.rda"))

  ##Return
  return(DEM.USGS.GT30.BCAB)

}


