#' Plots hazard chart base chart.
#'
#' Plots hazard chart base chart.
#' @param main Optional title for chart
#'
#' @examples
#' require(SarpGeneralVis)
#'
#' plotHzdChartBase()
#'
#' @export

plotHzdChartBase <- function (main="") {

  plot(c(1:9), c(1:9), t="n", xlab="Destructive Size", ylab="Likelihood of avalanches", ylim = c(0.5,9.5), xlim = c(0.5,9.5), xaxt="n", yaxt="n", main = main)
  axis(side = 1, at=c(1:9), labels = c("Sz 1", "", "Sz 2", "", "Sz 3", "", "Sz 4", "", "Sz 5"))
  axis(side = 2, at=c(1:9), labels = c("UL", "", "P", "", "L", "", "VL", "", "AC"), las=1)
  abline(v=c(1:9), lty="dotted", col="grey")
  abline(h=c(1:9), lty="dotted", col="grey")
  box()

}
