#' Plots CMHA likelihood base chart.
#'
#' Plots CMHA likeihood base chart.
#' @param main Optional title for chart
#'
#' @examples
#' require(SarpGeneralVis)
#'
#' plotLikeliChartBase()
#'
#' @export

plotLikeliChartBase <- function (main="") {

  plot(c(1:9), c(1:9), t="n", xlab="Sensitivity", ylab="Distribution", ylim = c(0.5,3.5), xlim = c(0.5,4.5), xaxt="n", yaxt="n", main = main)
  axis(side = 1, at=c(1:4), labels = c("Unreactive", "Stubborn", "Touchy", "Very Touchy"))
  axis(side = 2, at=c(1:3), labels = c("Isolated", "Specific", "Widespread"))
  abline(v=c(1:9), lty="dotted", col="grey")
  abline(h=c(1:9), lty="dotted", col="grey")
  box()

}
