#' Function for plotting Aspects for Wind Slab problems.
#'
#' Function for plotting hazard chart with Av problems.
#' @param AspectAssessObj GlacierBull dataframe from running the getGlacierBulletinsRaw.R function
#' @param ElevBand Switch for specifying elevation band. Default is 'All'. Additional possible values are 'Alp', 'Tl' or 'Btl'.
#' @param WithXAxis Switch for plotting x-axis (default=TRUE).
#' @param DateStart Start date for plot. If not provided, the function takes the date range of TblWx (default=NA).
#' @param DateEnd End date for plot. If not provided, the function takes the date range of TblWx (default=NA).
#' @param HighlightDateStart Start of highlighted time period (default=NA).
#' @param HighlightDateEnd End of highlighted time period (default=HighlightDateStart).
#' @param HighlightCol Color for highlighted time period (default="light grey").
#' @param cex.axis cex.axis (default=1.0).
#' @param cex.lab cex.lab (default=1.0).
#' @param cex.points cex.points (default=1.6).
#'
#'
#' @export

# source('bulletins/getGlacierBulletinsRaw.R')
# source('bulletins/getGlacierData.R')

# #
# # For testing
# WithXAxis=T
# main=""
# HighlightDateStart=NA
# HighlightDateEnd=HighlightDateStart
# HighlightCol="light grey"
# NoGlideNoCornice=F
# cex.axis=1.0
# cex.lab=1.0
# cex.points=1.6
# plotElevLabels=T
# plotWindAspect=T
#
# ElevBand <- "ALL"
# AspectAssessObj <- getGlacierBulletinsRaw()
#
# DateStart <- as.Date("2012-12-01")
# DateEnd <- as.Date("2013-04-01")

plotTSWindProbAspect <- function(AspectAssessObj,
                                 ElevBand = "ALL",
                                 WithXAxis=T,
                                 DateStart=NA,
                                 DateEnd=NA,
                                 main="",
                                 HighlightDateStart=NA,
                                 HighlightDateEnd=HighlightDateStart,
                                 HighlightCol="light grey",
                                 NoGlideNoCornice=F,
                                 cex.axis=1,
                                 cex.lab=1,
                                 cex.points=1.6,
                                 plotElevLabels=F) {


  print("... starting plotTSWindProbAspect")

  #AspectAssessObj$AvProblems[!grepl("Wind Slabs", AspectAssessObj$CHARACTER),]

  ## Check that Variable names are in CAPITAL LETTERS
  ElevBand <- toupper(ElevBand)
  if (ElevBand!="ALL" & ElevBand!="ALP" & ElevBand!="TL" & ElevBand!="BTL") {
    stop("Value of ElevBand parameter must be, 'ALL', 'ALP', 'TL' or 'BTL'!'")
  }

  ## Creating of TblPlot dataframe with all the needed variables
  TblPlot <- data.frame(id = AspectAssessObj$Bulletins$BULLETIN_ID,
                        date = AspectAssessObj$Bulletins$PUBLISH_DATE,
                        dng_alp = NA, dng_tl = NA, dng_btl = NA, av_character = NA,
                        ASP_N = 0,  ASP_N_ALP = 0,  ASP_N_TL = 0,  ASP_N_BTL = 0,
                        ASP_NE = 0,  ASP_NE_ALP = 0,  ASP_NE_TL = 0,  ASP_NE_BTL = 0,
                        ASP_E = 0,  ASP_E_ALP = 0,  ASP_E_TL = 0,  ASP_E_BTL = 0,
                        ASP_SE = 0,  ASP_SE_ALP = 0,  ASP_SE_TL = 0,  ASP_SE_BTL = 0,
                        ASP_S = 0,  ASP_S_ALP = 0,  ASP_S_TL = 0,  ASP_S_BTL = 0,
                        ASP_SW = 0, ASP_SW_ALP = 0, ASP_SW_TL = 0, ASP_SW_BTL = 0,
                        ASP_W = 0,  ASP_W_ALP = 0,  ASP_W_TL = 0,  ASP_W_BTL = 0,
                        ASP_NW = 0, ASP_NW_ALP = 0, ASP_NW_TL = 0, ASP_NW_BTL = 0)

  ## Transferring danger ratings
  DngRating <- AspectAssessObj$DngRating
  for (i in 1:nrow(TblPlot)) {
    BullID <- TblPlot$id[i]
    if(ElevBand=="ALL" | ElevBand=="ALP") {TblPlot$dng_alp[i] <- as.character(DngRating$Alp$DAY0[DngRating$Alp$BULLETIN_ID==BullID])}
    if(ElevBand=="ALL" | ElevBand=="TL") {TblPlot$dng_tl[i] <- as.character(DngRating$Tl$DAY0[DngRating$Tl$BULLETIN_ID==BullID])}
    if(ElevBand=="ALL" | ElevBand=="BTL") {TblPlot$dng_btl[i] <- as.character(DngRating$Btl$DAY0[DngRating$Btl$BULLETIN_ID==BullID])}
  }
  rm(DngRating, i)
  ## Transferring aspect information depending on ELEVATION
  Av_Character <- AspectAssessObj$AvProblems
  ALL_Av_Character <- getGlacierData()
  if (ElevBand=="ALL") {
    for (i in 1:nrow(TblPlot)) {
      BullID <- TblPlot$id[i]
      if (ALL_Av_Character$WIND_SLABS[ALL_Av_Character$BULLETIN_ID==BullID] > 0) {
        TblPlot$av_character[i] <- "Wind Slabs"
        ## *** When 'ALL' elevation bands is chosen, the assumption is made that the Aspects for ALP reflect all the aspects for that given day
        TblPlot$ASP_N[i] <- Av_Character$Alp$ASP_N[(Av_Character$Alp$BULLETIN_ID==BullID) & (Av_Character$Alp$CHARACTER=='Wind Slabs')]
        TblPlot$ASP_NE[i] <- Av_Character$Alp$ASP_NE[(Av_Character$Alp$BULLETIN_ID==BullID) & (Av_Character$Alp$CHARACTER=='Wind Slabs')]
        TblPlot$ASP_E[i] <- Av_Character$Alp$ASP_E[(Av_Character$Alp$BULLETIN_ID==BullID) & (Av_Character$Alp$CHARACTER=='Wind Slabs')]
        TblPlot$ASP_SE[i] <- Av_Character$Alp$ASP_SE[(Av_Character$Alp$BULLETIN_ID==BullID) & (Av_Character$Alp$CHARACTER=='Wind Slabs')]
        TblPlot$ASP_S[i] <- Av_Character$Alp$ASP_S[(Av_Character$Alp$BULLETIN_ID==BullID) & (Av_Character$Alp$CHARACTER=='Wind Slabs')]
        TblPlot$ASP_SW[i] <- Av_Character$Alp$ASP_SW[(Av_Character$Alp$BULLETIN_ID==BullID) & (Av_Character$Alp$CHARACTER=='Wind Slabs')]
        TblPlot$ASP_W[i] <- Av_Character$Alp$ASP_W[(Av_Character$Alp$BULLETIN_ID==BullID) & (Av_Character$Alp$CHARACTER=='Wind Slabs')]
        TblPlot$ASP_NW[i] <- Av_Character$Alp$ASP_NW[(Av_Character$Alp$BULLETIN_ID==BullID) & (Av_Character$Alp$CHARACTER=='Wind Slabs')]
      } else {
        TblPlot$av_character[i] <- NA
        TblPlot$ASP_N[i] <- NA
        TblPlot$ASP_NE[i] <- NA
        TblPlot$ASP_E[i] <- NA
        TblPlot$ASP_SE[i] <- NA
        TblPlot$ASP_S[i] <- NA
        TblPlot$ASP_SW[i] <- NA
        TblPlot$ASP_W[i] <- NA
        TblPlot$ASP_NW[i] <- NA
      }
    }
  } else {
    for (i in 1:nrow(TblPlot)) {
      BullID <- TblPlot$id[i]
      if(ElevBand=="ALP") {
        if (any((Av_Character$Alp$CHARACTER[Av_Character$Alp$BULLETIN_ID==BullID] == "Wind Slabs")) > 0) {
          TblPlot$av_character[i] <- "Wind Slabs"
          TblPlot$ASP_N_ALP[i] <- Av_Character$Alp$ASP_N[(Av_Character$Alp$BULLETIN_ID==BullID) & (Av_Character$Alp$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_NE_ALP[i] <- Av_Character$Alp$ASP_NE[(Av_Character$Alp$BULLETIN_ID==BullID) & (Av_Character$Alp$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_E_ALP[i] <- Av_Character$Alp$ASP_E[(Av_Character$Alp$BULLETIN_ID==BullID) & (Av_Character$Alp$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_SE_ALP[i] <- Av_Character$Alp$ASP_SE[(Av_Character$Alp$BULLETIN_ID==BullID) & (Av_Character$Alp$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_S_ALP[i] <- Av_Character$Alp$ASP_S[(Av_Character$Alp$BULLETIN_ID==BullID) & (Av_Character$Alp$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_SW_ALP[i] <- Av_Character$Alp$ASP_SW[(Av_Character$Alp$BULLETIN_ID==BullID) & (Av_Character$Alp$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_W_ALP[i] <- Av_Character$Alp$ASP_W[(Av_Character$Alp$BULLETIN_ID==BullID) & (Av_Character$Alp$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_NW_ALP[i] <- Av_Character$Alp$ASP_NW[(Av_Character$Alp$BULLETIN_ID==BullID) & (Av_Character$Alp$CHARACTER=='Wind Slabs')]
        } else {
          TblPlot$av_character[i] <- NA
          TblPlot$ASP_N_ALP[i] <- NA
          TblPlot$ASP_NE_ALP[i] <- NA
          TblPlot$ASP_E_ALP[i] <- NA
          TblPlot$ASP_SE_ALP[i] <- NA
          TblPlot$ASP_S_ALP[i] <- NA
          TblPlot$ASP_SW_ALP[i] <- NA
          TblPlot$ASP_W_ALP[i] <- NA
          TblPlot$ASP_NW_ALP[i] <- NA
        }
      } else if(ElevBand=="TL") {
        if (any((Av_Character$Tl$CHARACTER[Av_Character$Tl$BULLETIN_ID==BullID] == "Wind Slabs"))>0) {
          TblPlot$av_character[i] <- "Wind Slabs"
          TblPlot$ASP_N_TL[i] <- Av_Character$Tl$ASP_N[(Av_Character$Tl$BULLETIN_ID==BullID) & (Av_Character$Tl$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_NE_TL[i] <- Av_Character$Tl$ASP_NE[(Av_Character$Tl$BULLETIN_ID==BullID) & (Av_Character$Tl$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_E_TL[i] <- Av_Character$Tl$ASP_E[(Av_Character$Tl$BULLETIN_ID==BullID) & (Av_Character$Tl$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_SE_TL[i] <- Av_Character$Tl$ASP_SE[(Av_Character$Tl$BULLETIN_ID==BullID) & (Av_Character$Tl$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_S_TL[i] <- Av_Character$Tl$ASP_S[(Av_Character$Tl$BULLETIN_ID==BullID) & (Av_Character$Tl$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_SW_TL[i] <- Av_Character$Tl$ASP_SW[(Av_Character$Tl$BULLETIN_ID==BullID) & (Av_Character$Tl$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_W_TL[i] <- Av_Character$Tl$ASP_W[(Av_Character$Tl$BULLETIN_ID==BullID) & (Av_Character$Tl$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_NW_TL[i] <- Av_Character$Tl$ASP_NW[(Av_Character$Tl$BULLETIN_ID==BullID) & (Av_Character$Tl$CHARACTER=='Wind Slabs')]
        } else {
          TblPlot$av_character[i] <- NA
          TblPlot$ASP_N_TL[i] <- NA
          TblPlot$ASP_NE_TL[i] <- NA
          TblPlot$ASP_E_TL[i] <- NA
          TblPlot$ASP_SE_TL[i] <- NA
          TblPlot$ASP_S_TL[i] <- NA
          TblPlot$ASP_SW_TL[i] <- NA
          TblPlot$ASP_W_TL[i] <- NA
          TblPlot$ASP_NW_TL[i] <- NA
        }
      } else if(ElevBand=="BTL") {
        if (any((Av_Character$Btl$CHARACTER[Av_Character$Btl$BULLETIN_ID==BullID] == "Wind Slabs"))>0) {
          TblPlot$av_character[i] <- "Wind Slabs"
          TblPlot$ASP_N_BTL[i] <- Av_Character$Btl$ASP_N[(Av_Character$Btl$BULLETIN_ID==BullID) & (Av_Character$Btl$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_NE_BTL[i] <- Av_Character$Btl$ASP_NE[(Av_Character$Btl$BULLETIN_ID==BullID) & (Av_Character$Btl$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_E_BTL[i] <- Av_Character$Btl$ASP_E[(Av_Character$Btl$BULLETIN_ID==BullID) & (Av_Character$Btl$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_SE_BTL[i] <- Av_Character$Btl$ASP_SE[(Av_Character$Btl$BULLETIN_ID==BullID) & (Av_Character$Btl$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_S_BTL[i] <- Av_Character$Btl$ASP_S[(Av_Character$Btl$BULLETIN_ID==BullID) & (Av_Character$Btl$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_SW_BTL[i] <- Av_Character$Btl$ASP_SW[(Av_Character$Btl$BULLETIN_ID==BullID) & (Av_Character$Btl$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_W_BTL[i] <- Av_Character$Btl$ASP_W[(Av_Character$Btl$BULLETIN_ID==BullID) & (Av_Character$Btl$CHARACTER=='Wind Slabs')]
          TblPlot$ASP_NW_BTL[i] <- Av_Character$Btl$ASP_NW[(Av_Character$Btl$BULLETIN_ID==BullID) & (Av_Character$Btl$CHARACTER=='Wind Slabs')]
        } else {
          TblPlot$av_character[i] <- NA
          TblPlot$ASP_N_BTL[i] <- NA
          TblPlot$ASP_NE_BTL[i] <- NA
          TblPlot$ASP_E_BTL[i] <- NA
          TblPlot$ASP_SE_BTL[i] <- NA
          TblPlot$ASP_S_BTL[i] <- NA
          TblPlot$ASP_SW_BTL[i] <- NA
          TblPlot$ASP_W_BTL[i] <- NA
          TblPlot$ASP_NW_BTL[i] <- NA
        }
      }
    }
  }
  rm(Av_Character, i)

  ## assign date range for chart
  if(is.na(DateStart)) {DateStart <- min(TblPlot$date)}
  if(is.na(DateEnd))   {DateEnd   <- max(TblPlot$date)}

  DateStart <- as.Date(DateStart)
  DateEnd   <- as.Date(DateEnd)

  ## SET UP PLOT
  ylim_min <- 0
  ylim_max <- 9
  ylim <- c(ylim_min, ylim_max)

  plot(NULL, xlim=c(DateStart, DateEnd), ylim=ylim, yaxt="n", xaxt="n", ylab="", xlab="")
  addTimeGridAndHighlight(TblPlot$date, WithXAxis=WithXAxis,
                          HighlightDateStart=HighlightDateStart, HighlightDateEnd=HighlightDateEnd,
                          HighlightCol=HighlightCol, cex.axis=cex.axis, cex.lab=cex.lab)

  abline(h=c(1:8), lty=3, col="dark grey")
  axis(2, at=c(1:8), labels=c("NW", "W", "SW", "S", "SE", "E", "NE", "N"), cex.axis=cex.axis*0.5, cex.lab=cex.lab, las=1)

  title(main = main)

  box()

  ## add Av problems
  if (ElevBand=='ALL'){

    points(TblPlot$date, as.numeric(TblPlot$ASP_N)*8,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_NE)*7,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_E)*6, pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_SE)*5, pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_S)*4,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_SW)*3,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_W)*2,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_NW)*1, pch=19, col='black', cex=cex.points)

  } else if (ElevBand=='ALP'){

    points(TblPlot$date, as.numeric(TblPlot$ASP_N_ALP)*8,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_NE_ALP)*7,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_E_ALP)*6, pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_SE_ALP)*5, pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_S_ALP)*4,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_SW_ALP)*3,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_W_ALP)*2,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_NW_ALP)*1, pch=19, col='black', cex=cex.points)
  } else if (ElevBand=='TL'){

    points(TblPlot$date, as.numeric(TblPlot$ASP_N_TL)*8,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_NE_TL)*7,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_E_TL)*6, pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_SE_TL)*5, pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_S_TL)*4,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_SW_TL)*3,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_W_TL)*2,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_NW_TL)*1, pch=19, col='black', cex=cex.points)
  } else if (ElevBand=='BTL'){

    points(TblPlot$date, as.numeric(TblPlot$ASP_N_BTL)*8,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_NE_BTL)*7,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_E_BTL)*6, pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_SE_BTL)*5, pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_S_BTL)*4,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_SW_BTL)*3,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_W_BTL)*2,  pch=19, col='black', cex=cex.points)
    points(TblPlot$date, as.numeric(TblPlot$ASP_NW_BTL)*1, pch=19, col='black', cex=cex.points)
  }
} # End of function

#plotTSWindProbAspect(AspectAssessObj, ElevBand = ElevBand, DateStart = DateStart, DateEnd = DateEnd)
