#' Plot Likelihood or Size of Wind Slab Avalanche Problems
#'
#' Plot Likelihood or Size
#' @param TblAvProbSz_Ll Dataframe with Wx observations.
#' @param WithXAxis Switch for plotting x-axis (default=TRUE).
#' @param ElevBand Elevation Band --> ONLY "ALP", "TL", or "BTL" (no "ALL")
#' @param plotSz_Ll "LL" or "SZ"
#' @param DateStart Start date for plot. If not provided, the function takes the date range of TblWx (default=NA).
#' @param DateEnd End date for plot. If not provided, the function takes the date range of TblWx (default=NA).
#' @param HighlightDateStart Start of highlighted time period (default=NA).
#' @param HighlightDateEnd End of highlighted time period (default=HighlightDateStart).
#' @param HighlightCol Color for highlighted time period (default="light grey").
#' @param main Title of chart
#' @param cex.axis cex.axis (default=1.0).
#' @param cex.lab cex.lab (default=1.0).
#'
#'
#' @export

# FOR TESTING
# source("bulletins/getGlacierBulletinsRaw.R")
# TblAvProbSz_Ll <- getGlacierBulletinsRaw()
# DateStart = as.Date('2012-12-01')
# DateEnd = as.Date('2013-05-01')
# Season = '2013'
# ElevBand = 'ALP'
# WithXAxis=T
# HighlightDateStart=NA
# HighlightDateEnd=HighlightDateStart
# HighlightCol="light grey"
# plotType="Polygon"
# main=""
# cex.axis=1.0
# cex.lab=1.0
# plotSz_Ll='LL'

plotTS_WindAvProb_SzLl <- function(TblAvProbSz_Ll,
                                   ElevBand = NA,
                                   plotSz_Ll="",
                                   WithXAxis=T,
                                   DateStart=NA,
                                   DateEnd=NA,
                                   HighlightDateStart=NA,
                                   HighlightDateEnd=HighlightDateStart,
                                   HighlightCol="light grey",
                                   main="",
                                   cex.axis=1.0,
                                   cex.lab=1.0) {

  require(dplyr)
  require(naniar)
  print("... starting plotTS_WindAvProb_SzLl")

  ElevBand <- toupper(ElevBand)
  if (ElevBand!="ALP" & ElevBand!="TL" & ElevBand!="BTL") {
    stop("Value of ElevBand parameter must be 'ALP', 'TL' or 'BTL'!")
  }

  plotSz_Ll <- toupper(plotSz_Ll)
  if (plotSz_Ll!="LL" & plotSz_Ll!="SZ") {
    stop("Value of plotSz_Ll parameter must be 'LL' or 'SZ'!")
  }

  ## assign date range for chart
  if(is.na(DateStart)) {DateStart <- min(TblAvProbSz_Ll$Bulletins$PUBLISH_DATE)}
  if(is.na(DateEnd))   {DateEnd   <- max(TblAvProbSz_Ll$Bulletins$PUBLISH_DATE)}

  DateStart <- as.Date(DateStart)
  DateEnd   <- as.Date(DateEnd)

  if (ElevBand == "ALP") {
    ## Merging data frames and condensing columns
    TempAggreg <- TblAvProbSz_Ll$Bulletins[,c('BULLETIN_ID','PUBLISH_DATE','SEASON')] # Pulls columns from Bulletins dataframe to use with Av_Problems
    TblAvProbSz_Ll <- TblAvProbSz_Ll$AvProblems$Alp[,c('BULLETIN_ID','CHARACTER','LIKELIHOOD_MIN','LIKELIHOOD_TYP','LIKELIHOOD_MAX','SIZE_MIN','SIZE_TYP','SIZE_MAX')]
    TblAvProbSz_Ll <- merge(TempAggreg, TblAvProbSz_Ll, by.x ='BULLETIN_ID') # merges the two dataframes
    TblAvProbSz_Ll <- subset(TblAvProbSz_Ll, !(duplicated(TblAvProbSz_Ll$PUBLISH_DATE) & (TblAvProbSz_Ll$CHARACTER!='Wind Slabs'))) # removes any duplicate date rows that don't equal Wind Slabs
    TblAvProbSz_Ll$CHARACTER[TblAvProbSz_Ll$CHARACTER!='Wind Slabs'] <- NA # changes any left over Av_Problems in the first date slot or dates w/o Wind Slabs into NAs
    TblAvProbSz_Ll <- arrange(TblAvProbSz_Ll, PUBLISH_DATE, CHARACTER) # rearranges Wind Slab to be the first problem for all dates
    TblAvProbSz_Ll <- subset(TblAvProbSz_Ll, !(duplicated(TblAvProbSz_Ll$PUBLISH_DATE))) # removes final date duplicates leaving dates w/o Wind Slabs as NA
    TblAvProbSz_Ll[!complete.cases(TblAvProbSz_Ll$CHARACTER), c('LIKELIHOOD_MIN','LIKELIHOOD_TYP','LIKELIHOOD_MAX','SIZE_MIN','SIZE_TYP','SIZE_MAX')] <- NA
  } else if (ElevBand == "TL") {
    ## Merging data frames and condensing columns
    TempAggreg <- TblAvProbSz_Ll$Bulletins[,c('BULLETIN_ID','PUBLISH_DATE','SEASON')] # Pulls columns from Bulletins dataframe to use with Av_Problems
    TblAvProbSz_Ll <- TblAvProbSz_Ll$AvProblems$Tl[,c('BULLETIN_ID','CHARACTER','LIKELIHOOD_MIN','LIKELIHOOD_TYP','LIKELIHOOD_MAX','SIZE_MIN','SIZE_TYP','SIZE_MAX')]
    TblAvProbSz_Ll <- merge(TempAggreg, TblAvProbSz_Ll, by.x ='BULLETIN_ID') # merges the two dataframes
    TblAvProbSz_Ll <- subset(TblAvProbSz_Ll, !(duplicated(TblAvProbSz_Ll$PUBLISH_DATE) & (TblAvProbSz_Ll$CHARACTER!='Wind Slabs'))) # removes any duplicate date rows that don't equal Wind Slabs
    TblAvProbSz_Ll$CHARACTER[TblAvProbSz_Ll$CHARACTER!='Wind Slabs'] <- NA # changes any left over Av_Problems in the first date slot or dates w/o Wind Slabs into NAs
    TblAvProbSz_Ll <- arrange(TblAvProbSz_Ll, PUBLISH_DATE, CHARACTER) # rearranges Wind Slab to be the first problem for all dates
    TblAvProbSz_Ll <- subset(TblAvProbSz_Ll, !(duplicated(TblAvProbSz_Ll$PUBLISH_DATE))) # removes final date duplicates leaving dates w/o Wind Slabs as NA
    TblAvProbSz_Ll[!complete.cases(TblAvProbSz_Ll$CHARACTER), c('LIKELIHOOD_MIN','LIKELIHOOD_TYP','LIKELIHOOD_MAX','SIZE_MIN','SIZE_TYP','SIZE_MAX')] <- NA
  } else if (ElevBand == "BTL") {
    ## Merging data frames and condensing columns
    TempAggreg <- TblAvProbSz_Ll$Bulletins[,c('BULLETIN_ID','PUBLISH_DATE','SEASON')] # Pulls columns from Bulletins dataframe to use with Av_Problems
    TblAvProbSz_Ll <- TblAvProbSz_Ll$AvProblems$Btl[,c('BULLETIN_ID','CHARACTER','LIKELIHOOD_MIN','LIKELIHOOD_TYP','LIKELIHOOD_MAX','SIZE_MIN','SIZE_TYP','SIZE_MAX')]
    TblAvProbSz_Ll <- merge(TempAggreg, TblAvProbSz_Ll, by.x ='BULLETIN_ID') # merges the two dataframes
    TblAvProbSz_Ll <- subset(TblAvProbSz_Ll, !(duplicated(TblAvProbSz_Ll$PUBLISH_DATE) & (TblAvProbSz_Ll$CHARACTER!='Wind Slabs'))) # removes any duplicate date rows that don't equal Wind Slabs
    TblAvProbSz_Ll$CHARACTER[TblAvProbSz_Ll$CHARACTER!='Wind Slabs'] <- NA # changes any left over Av_Problems in the first date slot or dates w/o Wind Slabs into NAs
    TblAvProbSz_Ll <- arrange(TblAvProbSz_Ll, PUBLISH_DATE, CHARACTER) # rearranges Wind Slab to be the first problem for all dates
    TblAvProbSz_Ll <- subset(TblAvProbSz_Ll, !(duplicated(TblAvProbSz_Ll$PUBLISH_DATE))) # removes final date duplicates leaving dates w/o Wind Slabs as NA
    TblAvProbSz_Ll[!complete.cases(TblAvProbSz_Ll$CHARACTER), c('LIKELIHOOD_MIN','LIKELIHOOD_TYP','LIKELIHOOD_MAX','SIZE_MIN','SIZE_TYP','SIZE_MAX')] <- NA
  } else {
    print("You have chosen an incorrect Elevation Band")
  }

  ## set up plot

  if (plotSz_Ll == 'LL') {
    plot(TblAvProbSz_Ll$PUBLISH_DATE, TblAvProbSz_Ll$LIKELIHOOD_MIN, col="blue", t="n", xlim=c(DateStart, DateEnd), ylim=c(min(TblAvProbSz_Ll$LIKELIHOOD_MIN,na.rm=TRUE)-1,max(TblAvProbSz_Ll$LIKELIHOOD_MAX,na.rm=TRUE)+1), xaxt="n", xlab="", ylab=c('Likelihood Scale'), las=1, cex.axis=cex.axis, cex.lab=cex.lab)
  } else if (plotSz_Ll == 'SZ') {
    plot(TblAvProbSz_Ll$PUBLISH_DATE, TblAvProbSz_Ll$SIZE_MIN, col="blue", t="n", xlim=c(DateStart, DateEnd), ylim=c(min(TblAvProbSz_Ll$SIZE_MIN,na.rm=TRUE)-1,max(TblAvProbSz_Ll$SIZE_MAX,na.rm=TRUE)+1), xaxt="n", xlab="", ylab=c('Size Scale'), las=1, cex.axis=cex.axis, cex.lab=cex.lab)
  }

  addTimeGridAndHighlight(TblAvProbSz_Ll$PUBLISH_DATE, WithXAxis=WithXAxis, HighlightDateStart=HighlightDateStart, HighlightDateEnd=HighlightDateEnd, HighlightCol=HighlightCol, cex.axis=cex.axis, cex.lab=cex.lab)
  box()
  title(main = main)

  ## plot data
  if(plotSz_Ll=="LL"){
    lines(TblAvProbSz_Ll$PUBLISH_DATE, TblAvProbSz_Ll$LIKELIHOOD_MIN, col="blue")
    lines(TblAvProbSz_Ll$PUBLISH_DATE, TblAvProbSz_Ll$LIKELIHOOD_MAX, col="red")
    lines(TblAvProbSz_Ll$PUBLISH_DATE, TblAvProbSz_Ll$LIKELIHOOD_TYP, col="black")
    points(TblAvProbSz_Ll$PUBLISH_DATE, TblAvProbSz_Ll$LIKELIHOOD_MIN, col="blue")
    points(TblAvProbSz_Ll$PUBLISH_DATE, TblAvProbSz_Ll$LIKELIHOOD_MAX, col="red")
    points(TblAvProbSz_Ll$PUBLISH_DATE, TblAvProbSz_Ll$LIKELIHOOD_TYP, col="black")
    # polx2 <- c(TblAvProbSz$PUBLISH_DATE[1:nrow(TblAvProbSz)],rev(TblAvProbSz$PUBLISH_DATE[1:nrow(TblAvProbSz)]))
    # poly2 <- c(TblAvProbSz$LIKELIHOOD_MIN[1:nrow(TblAvProbSz)],rev(TblAvProbSz$LIKELIHOOD_MAX[1:nrow(TblAvProbSz)]))
    # polygon(polx2,poly2,col="#E8E8E850", border=NA)
  } else if (plotSz_Ll=='SZ') {
    lines(TblAvProbSz_Ll$PUBLISH_DATE, TblAvProbSz_Ll$SIZE_MIN, col="blue")
    lines(TblAvProbSz_Ll$PUBLISH_DATE, TblAvProbSz_Ll$SIZE_MAX, col="red")
    lines(TblAvProbSz_Ll$PUBLISH_DATE, TblAvProbSz_Ll$SIZE_TYP, col="black")
    points(TblAvProbSz_Ll$PUBLISH_DATE, TblAvProbSz_Ll$SIZE_MIN, col="blue")
    points(TblAvProbSz_Ll$PUBLISH_DATE, TblAvProbSz_Ll$SIZE_MAX, col="red")
    points(TblAvProbSz_Ll$PUBLISH_DATE, TblAvProbSz_Ll$SIZE_TYP, col="black")
  }
} # end of function

#plotTS_WindAvProb_SzLl(TblAvProbSz_Ll, ElevBand = ElevBand, plotSz_Ll = "SZ", DateStart = DateStart, DateEnd = DateEnd)
