% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTSHzdRatingAvProb.R
\name{plotTSHzdRatingAvProb}
\alias{plotTSHzdRatingAvProb}
\title{Function for plotting hazard chart with Av problems.}
\usage{
plotTSHzdRatingAvProb(HzdAssessObj, ElevBand = "All", AvObs = NULL,
  SHObsDates = NULL, WithXAxis = T, DateStart = NA, DateEnd = NA,
  main = "", HighlightDateStart = NA,
  HighlightDateEnd = HighlightDateStart, HighlightCol = "light grey",
  NoGlideNoCornice = F, cex.axis = 1, cex.lab = 1,
  cex.points = 1.6, plotElevLabels = F, plotAvProb = T)
}
\arguments{
\item{HzdAssessObj}{InfoEx hazard assessment object.}

\item{ElevBand}{Switch for specifying elevation band. Default is 'All'. Additional possible values are 'Alp', 'Tl' or 'Btl'.}

\item{AvObs}{Optional dataframe with avalanche observations (default=NULL). IMPLEMENTATION NEED UPDATING!}

\item{SHObsDates}{Optional array with dates when SH was observed as AM/PM surface forms (default=NULL).}

\item{WithXAxis}{Switch for plotting x-axis (default=TRUE).}

\item{DateStart}{Start date for plot. If not provided, the function takes the date range of TblWx (default=NA).}

\item{DateEnd}{End date for plot. If not provided, the function takes the date range of TblWx (default=NA).}

\item{HighlightDateStart}{Start of highlighted time period (default=NA).}

\item{HighlightDateEnd}{End of highlighted time period (default=HighlightDateStart).}

\item{HighlightCol}{Color for highlighted time period (default="light grey").}

\item{cex.axis}{cex.axis (default=1.0).}

\item{cex.lab}{cex.lab (default=1.0).}

\item{cex.points}{cex.points (default=1.6).}

\item{plotElevLabels}{Switch for plotting the elevation band labels (default=F).}

\item{plotAvProb}{Switch for plotting Av problems (default=TRUE).}
}
\description{
Function for plotting hazard chart with Av problems.
}
\examples{
require(SarpGeneralVis)

## InfoEx avalanche hazard objects
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "MPS"

DateStart <- "2015-12-15"
DateEnd <- "2016-04-15"

## Get HzdAssess object for PM assessment
HzdAssess <- getInfoExHzdAssessObject(Operation, DateStart=DateStart, DateEnd=DateEnd, Time="PM")

## Standard plot
plotTSHzdRatingAvProb(HzdAssess, main="Hazard assessment for MPS (Winter 2016)")

## Bulletin avalanche hazard objects
require(SarpBulletinTools)

load(url("http://data.avalancheresearch.ca/AllBulletins_2010To2018.RData"))
GlacierBullID <- Bulletins$Bulletins$BULLETIN_ID[Bulletins$Bulletins$REGION=="Glacier" & Bulletins$Bulletins$SEASON==2017]
GlacierBull <- extractFromBulletinObj(Bulletins, ByBulletinID = GlacierBullID)
summary(GlacierBull)

plotTSHzdRatingAvProb(GlacierBull, main="Glacier NP avalanche problems (winter 2017)")
plotTSHzdRatingAvProb(GlacierBull, ElevBand = "alp", main="Glacier NP avalanche problems (winter 2017) - ALP only")
plotTSHzdRatingAvProb(GlacierBull, ElevBand = "tl", main="Glacier NP avalanche problems (winter 2017) - TL only")
plotTSHzdRatingAvProb(GlacierBull, ElevBand = "btl", main="Glacier NP avalanche problems (winter 2017) - BTL only")

}
