% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTSWxSnow.R
\name{plotTSWxSnow}
\alias{plotTSWxSnow}
\title{Plot snow height and precipitation chart}
\usage{
plotTSWxSnow(TblWx, WithXAxis = T, DateStart = NA, DateEnd = NA,
  HighlightDateStart = NA, HighlightDateEnd = HighlightDateStart,
  HighlightCol = "light grey", HsOffset = 100, Hn24Offset = 110,
  Hn24Scale = 2, SHShow = TRUE, SHOffset = 15, HsCol = "black",
  Hn24Col = "grey", RainCol = "grey10", cex.axis = 1, cex.lab = 1,
  WxSiteName = NULL)
}
\arguments{
\item{TblWx}{Dataframe with Wx observations. The following columns are needed: date, hn24, rainfall, hs, snow_form_1 (optional), snow_form_2 (optional)}

\item{WithXAxis}{Switch for plotting x-axis (default=TRUE).}

\item{DateStart}{Start date for plot. If not provided, the function takes the date range of TblWx (default=NA).}

\item{DateEnd}{End date for plot. If not provided, the function takes the date range of TblWx (default=NA).}

\item{HighlightDateStart}{Start of highlighted time period (default=NA).}

\item{HighlightDateEnd}{End of highlighted time period (default=HighlightDateStart).}

\item{HighlightCol}{Color for highlighted time period (default="light grey").}

\item{HsOffset}{Offset for HS plot (default=100).}

\item{Hn24Offset}{Offset for HN24 plot (default=110).}

\item{Hn24Scale}{Scale for HN24 plot(default=2).}

\item{SHShow}{Switch for showing SH icons on top of snowpack in chart (Default=TRUE).}

\item{SHOffset}{Offset for SH plot(default=15).}

\item{HsCol}{Color for HS (default="black").}

\item{Hn24Col}{Color for HN24 (default="grey").}

\item{RainCol}{Color for Rain (default="grey10").}

\item{cex.axis}{cex.axis (default=1.0).}

\item{cex.lab}{cex.lab (default=1.0).}

\item{WxSiteName}{WxSiteName (default=NULL).}
}
\description{
Plot snow height and precipitation chart.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)
require(SarpGeneralVis)

Operation <- "MPS"
WxSite <- "Lodge Weather Plot"

DateStart <- "2015-12-15"
DateEnd <- "2016-04-15"

## Get InfoExWxObs for a specific Wx station and time period
TblWx <- getInfoExWxObs(Operation, WxSiteName=WxSite, DateStart=DateStart, DateEnd=DateEnd)

## Standard plot
plotTSWxSnow(TblWx)

## Adjust colors of HS, HN24, Rain
plotTSWxSnow(TblWx, HsCol="darkred", Hn24Col="cyan2", RainCol="darkblue")

}
