% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTSWxTemp.R
\name{plotTSWxTemp}
\alias{plotTSWxTemp}
\title{Plot temperature}
\usage{
plotTSWxTemp(TblWx, WithXAxis = T, DateStart = NA, DateEnd = NA,
  HighlightDateStart = NA, HighlightDateEnd = HighlightDateStart,
  HighlightCol = "light grey", plotType = "Lines", main = "",
  cex.axis = 1, cex.lab = 1, Verbose = F)
}
\arguments{
\item{TblWx}{Dataframe with Wx observations.}

\item{WithXAxis}{Switch for plotting x-axis (default=TRUE).}

\item{DateStart}{Start date for plot. If not provided, the function takes the date range of TblWx (default=NA).}

\item{DateEnd}{End date for plot. If not provided, the function takes the date range of TblWx (default=NA).}

\item{HighlightDateStart}{Start of highlighted time period (default=NA).}

\item{HighlightDateEnd}{End of highlighted time period (default=HighlightDateStart).}

\item{HighlightCol}{Color for highlighted time period (default="light grey").}

\item{plotType}{Type of temperature plot. Possible types are "Lines" and "Polygon" (default="Lines").}

\item{main}{Title of chart}

\item{cex.axis}{cex.axis (default=1.0).}

\item{cex.lab}{cex.lab (default=1.0).}

\item{Verbose}{Swtich for turning messages on or off (default value FALSE).}
}
\description{
Plot temperature.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)
require(SarpGeneralVis)

Operation <- "NEH"
DateStart <- "2015-01-01"
DateEnd <- "2015-03-31"

## Get InfoExWxObs for a specific Wx station and time period
TblWx <- getInfoExWxObs(Operation=Operation, WxSiteName="Shames", DateStart=DateStart, DateEnd=DateEnd)

## Standard plot with lines for min and max temperature
plotTSWxTemp(TblWx, plotType = "Lines")

## Adjusted size of axis text and axis labels
plotTSWxTemp(TblWx, plotType = "Lines", cex.axis=1.5, cex.lab=1.5)

## Standard plot with shaded polygon for min and max temperature and mean temperature as line
plotTSWxTemp(TblWx, plotType = "Polygon")

## Color one part of a time series and shade the rest, adjust the color of the highlight
plotTSWxTemp(TblWx, plotType = "Polygon", HighlightDateStart=as.Date("2015-02-18"), HighlightCol = "#C0C0C050")

}
