% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTSWxWind.R
\name{plotTSWxWind}
\alias{plotTSWxWind}
\title{Plot average Wind Direction and Speed}
\usage{
plotTSWxWind(TblWx, WithXAxis = T, DateStart = NA, DateEnd = NA,
  ShowTestArrows = F, ScaleX = 2.5, ScaleY = 0.1, Level = 0.2,
  HighlightDateStart = NA, HighlightDateEnd = HighlightDateStart,
  HighlightCol = "light grey", plotType = "Lines", main = "",
  cex.axis = 1, cex.lab = 1, Verbose = F)
}
\arguments{
\item{TblWx}{Dataframe with Wx observations.}

\item{WithXAxis}{Switch for plotting x-axis (default=TRUE).}

\item{DateStart}{Start date for plot. If not provided, the function takes the date range of TblWx (default=NA).}

\item{DateEnd}{End date for plot. If not provided, the function takes the date range of TblWx (default=NA).}

\item{ShowTestArrows}{Adds X & Y arrows to allow for visual adjustment of ScaleX and ScaleY (default=F)}

\item{ScaleX}{Scale used to adjust the wind direction arrows x-axis (default is 2.5)}

\item{ScaleY}{Scale used to adjust the wind direction arrows y-axis (default is 0.1)}

\item{HighlightDateStart}{Start of highlighted time period (default=NA).}

\item{HighlightDateEnd}{End of highlighted time period (default=HighlightDateStart).}

\item{HighlightCol}{Color for highlighted time period (default="light grey").}

\item{plotType}{Type of plot. Possible types are "Lines" and "Polygon" (default="Lines").}

\item{main}{Title of chart}

\item{cex.axis}{cex.axis (default=1.0).}

\item{cex.lab}{cex.lab (default=1.0).}
}
\description{
Plot average Wind Direction and Speed
}
