% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTerrain.R
\name{plotTerrain}
\alias{plotTerrain}
\title{Plots terrain in either grey scale or with terrain colors based on DEM}
\usage{
plotTerrain(DEM, Type = "Elev", Elev.ClrType = "Terrain",
  Elev.Hsh = T, Elev.Min = 0, Elev.Max = 4000, Elev.Step = 100,
  Elev.BtlTl = 1800, Elev.TlAlp = 2400, Elev.Clr = c("#E8E8E8",
  "#808080"), Elev.Cont = F, Elev.Cont.Clr = NA,
  Elev.WithHsh.alpha = 0.35, Slp.Hsh = T, Slp.Int = c(0, 20, 25, 30,
  35, 40, 45, 50, 90), Slp.Clr = NA, Slp.ClrBrewer = "OrRd",
  Slp.Cont = F, Slp.Cont.Clr = NA, Slp.WithHsh.alpha = 0.35,
  alpha = 1, add = F, ...)
}
\arguments{
\item{DEM}{raster with elevation data.}

\item{Type}{Type of terrain plot. Default is 'Elev'. Other option is 'Slope'.}

\item{Elev.Hsh}{Switch for showing hillshade in the background. Default is TRUE}

\item{Elev.Min}{Start of elevation range. Default value is 0. Only used when applying monochrome scale.}

\item{Elev.Max}{End of elevation range. Default value is 4000.}

\item{Elev.Step}{Elevation intervals for terrain shading. Default is 100m.}

\item{Elev.BtlTl}{Elevation of BTL-TL boundary. Default is 1800m}

\item{Elev.TlAlp}{Elevation of TL-ALP boundary. Default is 2400m.}

\item{Elev.Clr}{Array of two color for monochromatic elevation shading. Default are two grey shades c("#E8E8E8", "#808080").}

\item{Elev.Cont}{Switch for adding elevation contour lines. Default is FALSE.}

\item{Elev.Cont.Clr}{Color of elevation contours.}

\item{Elev.WithHsh.alpha}{Transparency of elevation shading layer if hillshade is included. Default is 0.35,}

\item{Slp.Hsh}{Switch for showing hillshade in the background of slope shading. Default is TRUE,}

\item{Slp.Int}{Breaks for slope shading. Default is c(0, 20, 25, 30, 35, 40, 45, 50, 90)}

\item{Slp.Clr}{Array of two color for monochromatic elevation shading. Default is NA.}

\item{Slp.ClrBrewer}{Name of Colorbrewer scale for slope shading. Default is "OrRd"}

\item{Slp.Cont}{Switch for adding slope incline contour lines. Default is FALSE.}

\item{Slp.Cont.Clr}{Color of elevation contours.}

\item{Slp.WithHsh.alpha}{Transparency of slope shading layer if hillshade is included. Default is 0.35,}

\item{alpha}{Transparency of entire chart. Default is 1.}

\item{add}{Switch for whether plot should be added to existing plot (default=F)}

\item{...}{Any other parameters that can be added to the plot function.}

\item{Elev.Clr.Type}{Type of terrain shading. Default is 'Terrain'. Other option is 'Monochrome'}
}
\description{
Plots terrain in either grey scale or with terrain colors based on DEM
}
\examples{
require(SarpGeneralVis)

## Get test DEM
DEM <- getDEM_BCAB()

## Default: hilshade with terrain colors
plotTerrain(DEM)

## Hillshade only
plotTerrain(DEM, Elev.WithHsh.alpha=0)

## Grey scale with default 200m intervals
plotTerrain(DEM, Elev.Clr.Type="Monochrome", Elev.Step=500, Elev.Hsh=F)

}
