% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTerrain_BCAB.R
\name{plotTerrain_BCAB}
\alias{plotTerrain_BCAB}
\title{Plots topography of BC and AB as background}
\usage{
plotTerrain_BCAB(Elev.Step = 500, Elev.Clr = c("#E8E8E8", "#808080"),
  ClrBoundary = "#606060", WithBoundaries = T, add = F, ...)
}
\arguments{
\item{ClrBoundary}{Color of provincial boundaries}

\item{add}{Switch for whether plot should be added to existing plot (default=F)}

\item{ElevBy}{Size of elevation steps between 0 and 4000m (default: 500m)}

\item{ClrStart}{Color of lowest elevation category}

\item{ClrEnd}{Color of higest elevation category}

\item{WithBoundary}{Switch for including provincial boundaries (default=T)}
}
\description{
Plots topography of BC and AB as background
}
\examples{
require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)

BullRegionAvCan <- getBulletinRegionGeomSPDF(Season = 2018, Agency = "AvCan")
BullRegionPkCan <- getBulletinRegionGeomSPDF(Season = 2018, Agency = "PkCan")
BullRegionC <- getBulletinRegionGeomSPDF(Season = 2018, AsCentroid = T)

## Base plot
plot(BullRegionAvCan)
plotTerrain_BCAB(add=T)

## Bulletin regions
plot(BullRegionAvCan, col="#377eb880", lwd=2, add=T)
plot(BullRegionPkCan, col="#4daf4a80", lwd=2, add=T)

## Labels
text(BullRegionC, labels=BullRegionC$name)

## box
box()
title("Public avalanche bulletin regions in western Canada (2018)")

}
