#' Adds an alpha value to a colour.
#'
#' Adds an alpha value to a colour.
#' @param col Single or array of colors.
#' @param alpha alpha value (default=1).
#' @return Single value or array of colors with alpha.
#'
#' @examples
#' col <- "red"
#' col <- addAlphaToColor(col, 0.7)
#'
#' col <- #FF0000
#' col <- addAlphaToColor(col, 0.7)
#'
#' @export


addAlphaToColor <- function(col, alpha=1){
  if(missing(col))
    stop("Please provide a vector of colours.")
  apply(sapply(col, col2rgb)/255, 2,
        function(x)
          rgb(x[1], x[2], x[3], alpha=alpha))
}
