#' Adding a list of IDs to the where condition of a query
#'
#' Adding a list of IDs to the where condition of a query
#' @param Query Original query
#' @param IDArray Array of IDs to be included in the where condition
#' @param IDColName Name of ID column in database
#' @param Connector Steing with connector between existing query and ID conditions. Default is "WHERE". Could also be "AND" or "OR".
#' @param InBrackets Switch for whether all of the ID conditions could be framed with a single set of brackets. Default is FALSE.
#' @param WithQuotes Switch for whether quotes should be added around ID values. Default is FALSE.
#' @return Final query
#'
#' @export

addIDsToSQLQuery <- function (Query, IDArray, IDColName,  Connector = "WHERE", InBrackets=F, WithQuotes=F) {

  Query <- paste0(Query, " ", Connector, " ")

  if (InBrackets) {Query <- paste0(Query, "(")}

  IDArray_Length <- length(IDArray)

  for (Index in 1:IDArray_Length) {

    if (WithQuotes) {
      IDValue <- paste0("'", IDArray[Index], "'")
    } else {
      IDValue <- IDArray[Index]
    }

    Query <- paste0(Query, IDColName, "=", IDValue, ifelse(Index==IDArray_Length, "", " OR "))

  }

  if (InBrackets) {Query <- paste0(Query, ")")}

  return (Query)

}
