#' Function that repeats calls to Database
#'
#' Function that repeats calls to Database, a potential solution for random connectivity issues.
#' @param DBFunction A function that calls database.
#' @param MaxNumTries Number of maximum tries that are attempted. Default value is 10.
#' @return DBObject Object called from Database.
#'
#' @examples
#'	require(SarpBulletinTools)
#'	require(SarpBulletinToolsPrivate)
#'	require(SarpGeneral)
#'	reg <- c("South Coast","North Columbia","South Columbia","Kootenay Boundary","South Rockies","Northwest - BC","North Rockies - BC")
#'	avPr <- c('Storm Slabs','Wind Slabs', 'Persistent Slabs', 'Deep Persistent Slabs','Wet Slabs','Loose Wet','Loose Dry','Cornices' )
#'	# Loop for Region list
#'	for(r in 1:length(reg))
#'	{
#'		# Loop for Avalanche Problems
#'		for(a in 1:length(avPr))
#'		{
#'			Bulletins <- callDB(getBulletins(Agency = 'AvCan',
#'		                              Seasons = 2010,
#'		                              Regions = reg[r]))
#'			AlpAvProb <- Bulletins$AvProblems[['Alp']]
#'			plotHzdChartCount(AlpAvProb[AlpAvProb$CHARACTER==avPr[a],],
#'			                  Shape = "Square",
#'			                  Percent = TRUE,
#'			                  PercentInterval=10,
#'			                  Title=paste0('2010 ', reg[r], ': Alp ',avPr[a]),
#'			                  cex.AdditionalText=0.75)
#'		}
#'	}
#'
#' @export

callDB <- function(DBFunction, MaxNumTries=10) {

  warning(paste0("Deprecated! Use tryMultipleTimes instead"), immediate.=T)
	Success <- FALSE
	Tries <- 0
	repeat{
		# exit condition
		if(Success == TRUE) break
	  if(Tries > MaxNumTries) {
	    warning(paste0("Unsuccessful, but maximum number of tries reached (", MaxNumTries, ")"), immediate.=T)
	    DBObj <- NA
	    break
	  }
		# desired database call
	  DBObj <- try(DBFunction)
		Tries <- Tries + 1
		if(class(DBObj)[1] == 'try-error' ) {
			#warning('Unable to connect to database!', immediate.=T)
			Sys.sleep(5)
			print(paste0('Trying again ... (', Tries, ' of ', MaxNumTries, ')'))
		} else {
			Success <- TRUE
		}
	}
	return(DBObj)
}
