#' Converts a PostgreSQL array value to a vector value in R.
#'
#' Converts an array value from a PostgreSQL query to a vector value in R.
#' @param Array A PostgreSQL array value
#' @param Numeric Switch whether output vector is numeric (T, default) or character (F)
#' @return Vector value
#' @export

convertArrayFromSQL <- function(Array, Numeric=T) {

  if (is.null(Array)) {
    Output <- NA
  } else if (is.na(Array)) {
    Output <- NA
  } else if (nchar(Array)==0) {
    Output <- NA
  } else {
    ## Remove curley brackets
    Output <- substr(Array, 2, (nchar(Array)-1))
    ## Split string
    Output <- unlist(strsplit(Output, ","))
    ## Replace nulls
    Output <- replace(Output, Output=="NULL", NA)
    ## Convert into numeric
    if (Numeric) {Output <- as.numeric(Output)}
  }
  return(Output)

}
