#' Converts a boolean value for a SQL query
#'
#' Converts a boolean value into a boolean for a SQL query
#' @param Boolean A boolean value
#' @return MySQL compatible string value
#' @export

convertBooleanToSQL <- function(Boolean) {

  if (is.null(Boolean)) {
    Output <- "null"
  } else if (length(Boolean)==0) {
    Output <- "null"
  } else if (is.na(Boolean)) {
    Output <- "null"
  } else {
    Output <- Boolean
  }
  return(Output)

}
