#' Day number since the beginning of the avalanche season (Oct.1)
#'
#' Converts date to day number since the beginning of the avalanche season (Oct.1)
#' @param Date Single or array of dates
#' @param StartDate Start of season date. Default value is Oct. 1.
#' @return Array with result
#'
#' @export

convertDate2DaySinceStartOfSeason <- function(Date, StartDate="10-01") {

  Date <- as.Date(Date)

  StartDate <- paste0("2015-", StartDate)
  StartDate <- as.numeric(strftime(as.Date(StartDate), format = "%j"))

  DaySinceJan1 <- as.numeric(strftime(Date, format = "%j"))
  DaySinceStartDate <- DaySinceJan1 - StartDate
  DaySinceStartDate <- ifelse(DaySinceStartDate<0, DaySinceStartDate+365, DaySinceStartDate)

  return (DaySinceStartDate)

}
