 #' Converts a date and time into a string for a SQL query
#'
#' Converts a chron times object into a string for a SQL query
#' @param DateTime A chron times object
#' @return SQL compatible string of DateTime with quotes
#' @export

convertDateTimeToSQL <- function(DateTime) {

  DateTimeString <- paste0("'", format(DateTime, "%Y-%m-%d %H:%M:%S"), "'")

  return(DateTimeString)
}
