#' Converts a date into a string for a SQL query
#'
#' Converts a chron dates object into a string for a SQL query
#' @param Date A chron date time object
#' @param Quotes Switch for whether to add quotes to date
#' @return SQL compatible string of Date with quotes
#' @export

convertDateToSQL <- function(Date, Quotes=TRUE) {

  Date <- as.character(Date)
  DateString <- paste0("20", substr(Date, 7,8), "-", substr(Date, 1,2), "-", substr(Date, 4,5))
  if (Quotes) {DateString <- paste0("'", DateString, "'")}

  return(DateString)
}
