#' Converts a numeric value for a MySQL query
#'
#' Converts a numeric value into a string for a SQL query
#' @param Numeric A numeric value
#' @return MySQL compatible string value of the numeric value
#' @export

convertNumericToSQL <- function(Numeric) {

  if (is.null(Numeric)) {
    Output <- "null"
  } else if (is.na(Numeric)) {
    Output <- "null"
  } else {
    Output <- Numeric
  }
  return(Output)

}

