#' Converts a string value for a SQL query
#'
#' Converts a string value into a string for a SQL query
#' @param String A string value
#' @return MySQL compatible string value
#' @export

convertStringToSQL <- function(String) {

  if (is.null(String)) {
    Output <- "null"
  } else if (length(String)==0) {
    Output <- "null"
  } else if (is.na(String)) {
    Output <- "null"
  } else {
    ## Escape quote
    String <- gsub("'", "''", String)
    ## Put in quotes
    Output <- paste0("'", String, "'")
  }
  return(Output)

}
