#' Converts a vector value to array for a PostgreSQL query
#'
#' Converts a vector value to array for a PostgreSQL query
#' @param Vector A vector value
#' @param Char Switch whether the vector contains character values. Default is false.
#' @return PostgreSQL compatible string value
#' @export

convertVectorToSQL <- function(Vector, Char=F) {

  if (is.null(Vector)) {
    Output <- "null"
  } else if (length(Vector)==0) {
    Output <- "null"
  } else {
    ## Vector of character elements
    if (Char) {
      ## Collapse vector
      String <- paste(Vector, collapse="','")
      ## Replace NA with null
      String <- gsub("'NA'", "null", String)
      ## Put in curly brackets and quotes
      Output <- paste0("ARRAY['", String, "']")
      ## Eliminate nulls with quotes
      Output <- gsub("'null", "null", Output)
      Output <- gsub("null'", "null", Output)

    ## Vector of numeric elements
    } else {
      ## Collapse vector
      String <- paste(Vector, collapse=",")
      ## Replace NA with null
      String <- gsub("NA", "null", String)
      ## Put in curly brackets and quotes
      Output <- paste0("'{", String, "}'")
    }
  }
  return(Output)

}
