#' Creates a single UUID value
#'
#' Creates UUID a single value. When applying to the column of a DF, use the lapply function: DF$UUID <- unlist(lapply(DF$SomeOtherColumn, function(x) createUuid()))
#' @param uppercase Switch for whether the character in the UUID should be upper case. Default value is FALSE.
#' @return Single UUID as character string.
#' @export

createUuid <- function(uppercase=FALSE) {

  hex_digits <- c(as.character(0:9), letters[1:6])
  hex_digits <- if (uppercase) toupper(hex_digits) else hex_digits

  UUID <- paste(paste0(sample(hex_digits, 8), collapse=''),
                paste0(sample(hex_digits, 4), collapse=''),
                paste0(sample(hex_digits, 4), collapse=''),
                paste0(sample(hex_digits, 4), collapse=''),
                paste0(sample(hex_digits, 12), collapse=''),
                sep='-')

  return(UUID)

}
