#' Deletes column in dataframe by name
#'
#' Deletes single or multiple columns in dataframe by name.
#' @param DF dataframe
#' @param ColNames Name of column(s) as single string or array of strings
#' @return Copy of original dataframe without deleted columns
#' @export

deleteDFColumnsByName <- function(DF, ColNames) {

  DF <- DF[,-which(names(DF) %in% ColNames)]
  return(DF)

}
