#' Derives avalanche season from date
#'
#' Derives avalanche season from date
#' @param Date Single or array of dates
#' @return Array with result
#'
#' @examples
#' Date <- as.Date(c("2015-03-01", "2015-11-01"))
#' Season <- deriveAvSeasonFromDate(Date)
#'
#' @export

deriveAvSeasonFromDate <- function(Date) {

  Date <- as.Date(Date)

  AvSeason <- ifelse((as.numeric(format(Date, "%m"))>9),
                      as.numeric(format(Date, "%Y"))+1,
                      as.numeric(format(Date, "%Y")))

  return (AvSeason)

}
